/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateLoginModule;

public class TextFileCertificateLoginModule
extends CertificateLoginModule {
    private static final String USER_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.user";
    private static final String ROLE_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.role";
    private Map<String, Set<String>> rolesByUser;
    private Map<String, Pattern> regexpByUser;
    private Map<String, String> usersByDn;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.usersByDn = this.load(USER_FILE_PROP_NAME, "", options).invertedPropertiesMap();
        this.regexpByUser = this.load(USER_FILE_PROP_NAME, "", options).regexpPropertiesMap();
        this.rolesByUser = this.load(ROLE_FILE_PROP_NAME, "", options).invertedPropertiesValuesMap();
    }

    @Override
    protected String getUserNameForCertificates(X509Certificate[] certs) throws LoginException {
        if (certs == null) {
            throw new LoginException("Client certificates not found. Cannot authenticate.");
        }
        String dn = this.getDistinguishedName(certs);
        return this.usersByDn.containsKey(dn) ? this.usersByDn.get(dn) : this.getUserByRegexp(dn);
    }

    @Override
    protected Set<String> getUserRoles(String username) throws LoginException {
        Set<String> userRoles = this.rolesByUser.get(username);
        if (userRoles == null) {
            userRoles = Collections.emptySet();
        }
        return userRoles;
    }

    private synchronized String getUserByRegexp(String dn) {
        String name = null;
        for (Map.Entry<String, Pattern> val : this.regexpByUser.entrySet()) {
            if (!val.getValue().matcher(dn).matches()) continue;
            name = val.getKey();
            break;
        }
        this.usersByDn.put(dn, name);
        return name;
    }
}

