/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.sse;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.sse.InboundSseEvent;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.microprofile.client.sse.SsePublisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SseSubscription
implements Subscription {
    private static final int DEFAULT_BUFFER_SIZE = SystemPropertyAction.getInteger((String)"org.apache.cxf.microprofile.client.sse.bufferSize", (int)256);
    private final SsePublisher publisher;
    private final Subscriber<? super InboundSseEvent> subscriber;
    private final AtomicLong requested = new AtomicLong();
    private final AtomicLong delivered = new AtomicLong();
    private final AtomicBoolean completed = new AtomicBoolean();
    private final AtomicBoolean canceled = new AtomicBoolean();
    private final LinkedList<InboundSseEvent> buffer = new LinkedList();
    private final AtomicInteger bufferSize = new AtomicInteger(DEFAULT_BUFFER_SIZE);

    SseSubscription(SsePublisher publisher, Subscriber<? super InboundSseEvent> subscriber) {
        this.publisher = publisher;
        this.subscriber = subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        if (this.canceled.get()) {
            return;
        }
        if (n < 1L) {
            this.fireError(new IllegalArgumentException("Only positive values may be requested - passed-in " + n));
            return;
        }
        this.requested.addAndGet(n);
        LinkedList<InboundSseEvent> linkedList = this.buffer;
        synchronized (linkedList) {
            AtomicLong atomicLong = this.delivered;
            synchronized (atomicLong) {
                InboundSseEvent bufferedEvent;
                while (this.delivered.get() < this.requested.get() && (bufferedEvent = this.buffer.pollFirst()) != null) {
                    this.subscriber.onNext((Object)bufferedEvent);
                    this.delivered.incrementAndGet();
                }
            }
        }
    }

    public void cancel() {
        this.canceled.set(true);
        this.publisher.removeSubscription(this);
    }

    void fireSubscribe() {
        this.subscriber.onSubscribe((Subscription)this);
    }

    void fireEvent(InboundSseEvent event) {
        if (this.completed.get() || this.canceled.get()) {
            return;
        }
        this.delivered.updateAndGet(l -> {
            if (l < this.requested.get()) {
                this.subscriber.onNext((Object)event);
                return l + 1L;
            }
            this.buffer(event);
            return l;
        });
        this.fireCompleteIfReady();
    }

    void fireCompleteIfReady() {
        if (this.completed.get() && this.buffer.isEmpty()) {
            this.subscriber.onComplete();
        }
    }

    void fireError(Throwable t) {
        if (this.completed.compareAndSet(false, true)) {
            this.subscriber.onError(t);
        }
    }

    void setBufferSize(int newSize) {
        this.bufferSize.set(newSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buffer(InboundSseEvent event) {
        LinkedList<InboundSseEvent> linkedList = this.buffer;
        synchronized (linkedList) {
            this.buffer.addLast(event);
            if (this.buffer.size() > this.bufferSize.get()) {
                this.buffer.removeFirst();
            }
        }
    }

    static boolean isActive(SseSubscription subscription) {
        return !subscription.completed.get() && !subscription.canceled.get();
    }

    void complete() {
        this.completed.set(true);
        this.fireCompleteIfReady();
    }
}

