/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultFileContentTest {
    private static final String expected = "testing";

    @Test
    public void testGetZeroContents() throws IOException {
        FileSystemManager fsManager = VFS.getManager();
        try (FileObject fo = fsManager.resolveFile(new File("."), "src/test/resources/test-data/size-0-file.bin");
             FileContent content = fo.getContent();){
            Assertions.assertEquals((long)0L, (long)content.getSize());
            Assertions.assertTrue((boolean)content.isEmpty());
            Assertions.assertEquals((Object)"", (Object)content.getString(StandardCharsets.UTF_8));
            Assertions.assertEquals((Object)"", (Object)content.getString(StandardCharsets.UTF_8.name()));
            Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])content.getByteArray());
        }
    }

    private void testInputStreamBufferSize(int bufferSize) throws Exception {
        Path temp = Files.createTempFile("temp-file-name", ".tmp", new FileAttribute[0]);
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.toAbsolutePath().toString());){
            file.getContent().getInputStream(bufferSize);
        }
    }

    @Test
    public void testInputStreamBufferSize0() throws Exception {
        this.testInputStreamBufferSize(0);
    }

    @Test
    public void testInputStreamBufferSize1() throws Exception {
        this.testInputStreamBufferSize(1);
    }

    @Test
    public void testInputStreamBufferSizeNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testInputStreamBufferSize(-2));
    }

    @Test
    public void testInputStreamClosedInADifferentThread() throws Exception {
        this.testStreamClosedInADifferentThread(FileContent::getInputStream);
    }

    @Test
    public void testMarkingWhenReadingEOS() throws Exception {
        Path temp = Files.createTempFile("temp-file-name", ".tmp", new FileAttribute[0]);
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.toAbsolutePath().toString());){
            try (OutputStream outputStream = file.getContent().getOutputStream();){
                outputStream.write(expected.getBytes());
                outputStream.flush();
            }
            try (InputStream stream = file.getContent().getInputStream();){
                int readCount = 0;
                if (stream.markSupported()) {
                    for (int i = 0; i < 10; ++i) {
                        stream.mark(0);
                        byte[] data = new byte[100];
                        readCount = stream.read(data, 0, 7);
                        stream.read();
                        Assertions.assertEquals((int)7, (int)readCount);
                        Assertions.assertEquals((Object)expected, (Object)new String(data).trim());
                        readCount = stream.read(data, 8, 10);
                        Assertions.assertEquals((int)-1, (int)readCount);
                        stream.reset();
                    }
                }
            }
        }
    }

    @Test
    public void testMarkingWorks() throws Exception {
        Path temp = Files.createTempFile("temp-file-name", ".tmp", new FileAttribute[0]);
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.toAbsolutePath().toString());){
            try (OutputStream outputStream = file.getContent().getOutputStream();){
                outputStream.write(expected.getBytes());
                outputStream.flush();
            }
            try (InputStream stream = file.getContent().getInputStream();){
                if (stream.markSupported()) {
                    for (int i = 0; i < 10; ++i) {
                        stream.mark(0);
                        byte[] data = new byte[100];
                        stream.read(data, 0, 7);
                        stream.read();
                        Assertions.assertEquals((Object)expected, (Object)new String(data).trim());
                        stream.reset();
                    }
                }
            }
        }
    }

    private void testOutputStreamBufferSize(int bufferSize) throws Exception {
        Path temp = Files.createTempFile("temp-file-name", ".tmp", new FileAttribute[0]);
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.toAbsolutePath().toString());){
            file.getContent().getOutputStream(bufferSize).close();
        }
    }

    @Test
    public void testOutputStreamBufferSize0() throws Exception {
        this.testOutputStreamBufferSize(0);
    }

    @Test
    public void testOutputStreamBufferSize1() throws Exception {
        this.testOutputStreamBufferSize(1);
    }

    @Test
    public void testOutputStreamBufferSizeNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testOutputStreamBufferSize(-1));
    }

    @Test
    public void testOutputStreamBufferSizeNegativeWithAppendFlag() throws Exception {
        Path temp = Files.createTempFile("temp-file-name", ".tmp", new FileAttribute[0]);
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.toAbsolutePath().toString());){
            Assertions.assertThrows(IllegalArgumentException.class, () -> file.getContent().getOutputStream(true, -1));
        }
    }

    @Test
    public void testOutputStreamClosedInADifferentThread() throws Exception {
        this.testStreamClosedInADifferentThread(FileContent::getOutputStream);
    }

    private <T extends Closeable> void testStreamClosedInADifferentThread(FailableFunction<FileContent, T, IOException> getStream) throws Exception {
        Path temp = Files.createTempFile("temp-file-name", ".tmp", new FileAttribute[0]);
        FileSystemManager fileSystemManager = VFS.getManager();
        try (FileObject file = fileSystemManager.resolveFile(temp.toAbsolutePath().toString());){
            Closeable stream = (Closeable)getStream.apply((Object)file.getContent());
            AtomicBoolean check = new AtomicBoolean();
            Thread thread = new Thread(() -> {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                check.set(true);
            });
            thread.start();
            thread.join();
            Assertions.assertTrue((boolean)check.get());
        }
    }
}

