/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

import java.util.HashMap;
import org.apache.commons.exec.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringUtilTest {
    StringUtilTest() {
    }

    @Test
    void testDefaultStringSubstitution() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        vars.put("bar", "BAR");
        Assertions.assertEquals((Object)"This is a FOO & BAR test", (Object)StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)true).toString());
        Assertions.assertEquals((Object)"This is a FOO & BAR test", (Object)StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)false).toString());
    }

    @Test
    void testErroneousTemplate() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        Assertions.assertEquals((Object)"This is a FOO & ${}} test", (Object)StringUtils.stringSubstitution((String)"This is a ${foo} & ${}} test", vars, (boolean)true).toString());
    }

    @Test
    void testIncompleteSubstitution() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        Assertions.assertEquals((Object)"This is a FOO & ${bar} test", (Object)StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)true).toString());
        try {
            StringUtils.stringSubstitution((String)"This is a ${foo} & ${bar} test", vars, (boolean)false).toString();
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    void testNoStringSubstitution() throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "FOO");
        vars.put("bar", "BAR");
        Assertions.assertEquals((Object)"This is a FOO & BAR test", (Object)StringUtils.stringSubstitution((String)"This is a FOO & BAR test", vars, (boolean)true).toString());
    }

    @Test
    void testQuoteArgument() throws Exception {
        Assertions.assertEquals((Object)"hi", (Object)StringUtils.quoteArgument((String)"'hi'"));
        Assertions.assertEquals((Object)"hi", (Object)StringUtils.quoteArgument((String)"\"hi\""));
        Assertions.assertEquals((Object)"\"echo 'hi'\"", (Object)StringUtils.quoteArgument((String)"echo 'hi'"));
        Assertions.assertEquals((Object)"'echo \"hi\"'", (Object)StringUtils.quoteArgument((String)"echo \"hi\""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringUtils.quoteArgument((String)"echo \"hi 'world'\""), (String)"Can't handle single and double quotes in same argument");
    }
}

