/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.shell.cli.RaftUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractCommand;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public class RaftMetaConfCommand
extends AbstractCommand {
    public static final String PEER_OPTION_NAME = "peers";
    public static final String PATH_OPTION_NAME = "path";
    private static final String RAFT_META_CONF = "raft-meta.conf";
    private static final String NEW_RAFT_META_CONF = "new-raft-meta.conf";

    public RaftMetaConfCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "raftMetaConf";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        String peersStr = cl.getOptionValue(PEER_OPTION_NAME);
        String path = cl.getOptionValue(PATH_OPTION_NAME);
        if (peersStr == null || path == null || peersStr.isEmpty() || path.isEmpty()) {
            this.printf("peers or path can't be empty.", new Object[0]);
            return -1;
        }
        ArrayList<RaftProtos.RaftPeerProto> raftPeerProtos = new ArrayList<RaftProtos.RaftPeerProto>();
        for (String address : peersStr.split(",")) {
            String peerId = RaftUtils.getPeerId(RaftMetaConfCommand.parseInetSocketAddress(address)).toString();
            raftPeerProtos.add(RaftProtos.RaftPeerProto.newBuilder().setId(ByteString.copyFrom((byte[])peerId.getBytes(StandardCharsets.UTF_8))).setAddress(address).setStartupRole(RaftProtos.RaftPeerRole.FOLLOWER).build());
        }
        try (InputStream in = Files.newInputStream(Paths.get(path, RAFT_META_CONF), new OpenOption[0]);
             OutputStream out = Files.newOutputStream(Paths.get(path, NEW_RAFT_META_CONF), new OpenOption[0]);){
            long index = ((RaftProtos.LogEntryProto.Builder)RaftProtos.LogEntryProto.newBuilder().mergeFrom(in)).build().getIndex();
            this.println("Index in the original file is: " + index);
            RaftProtos.LogEntryProto generateLogEntryProto = RaftProtos.LogEntryProto.newBuilder().setConfigurationEntry(RaftProtos.RaftConfigurationProto.newBuilder().addAllPeers(raftPeerProtos).build()).setIndex(index + 1L).build();
            this.printf("Generate new LogEntryProto info is:\n" + generateLogEntryProto, new Object[0]);
            generateLogEntryProto.writeTo(out);
        }
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> -%s <PARENT_PATH_OF_RAFT_META_CONF>", this.getCommandName(), PEER_OPTION_NAME, PATH_OPTION_NAME);
    }

    @Override
    public String getDescription() {
        return RaftMetaConfCommand.description();
    }

    @Override
    public Options getOptions() {
        return new Options().addOption(Option.builder().option(PEER_OPTION_NAME).hasArg().required().desc("Peer addresses seperated by comma").build()).addOption(Option.builder().option(PATH_OPTION_NAME).hasArg().required().desc("The parent path of raft-meta.conf").build());
    }

    public static String description() {
        return "Generate a new raft-meta.conf file based on original raft-meta.conf and new peers.";
    }
}

