/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.parsing.XPathParser;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XNode {
    private final Node node;
    private final String name;
    private final String body;
    private final Properties attributes;
    private final Properties variables;
    private final XPathParser xpathParser;

    public XNode(XPathParser xpathParser, Node node, Properties variables) {
        this.xpathParser = xpathParser;
        this.node = node;
        this.name = node.getNodeName();
        this.variables = variables;
        this.attributes = this.parseAttributes(node);
        this.body = this.parseBody(node);
    }

    public XNode newXNode(Node node) {
        return new XNode(this.xpathParser, node, this.variables);
    }

    public XNode getParent() {
        Node parent = this.node.getParentNode();
        if (!(parent instanceof Element)) {
            return null;
        }
        return new XNode(this.xpathParser, parent, this.variables);
    }

    public String getPath() {
        StringBuilder builder = new StringBuilder();
        Node current = this.node;
        while (current instanceof Element) {
            if (current != this.node) {
                builder.insert(0, "/");
            }
            builder.insert(0, current.getNodeName());
            current = current.getParentNode();
        }
        return builder.toString();
    }

    public String getValueBasedIdentifier() {
        StringBuilder builder = new StringBuilder();
        for (XNode current = this; current != null; current = current.getParent()) {
            String value;
            if (current != this) {
                builder.insert(0, "_");
            }
            if ((value = current.getStringAttribute("id", current.getStringAttribute("value", current.getStringAttribute("property", (String)null)))) != null) {
                value = value.replace('.', '_');
                builder.insert(0, "]");
                builder.insert(0, value);
                builder.insert(0, "[");
            }
            builder.insert(0, current.getName());
        }
        return builder.toString();
    }

    public String evalString(String expression) {
        return this.xpathParser.evalString(this.node, expression);
    }

    public Boolean evalBoolean(String expression) {
        return this.xpathParser.evalBoolean(this.node, expression);
    }

    public Double evalDouble(String expression) {
        return this.xpathParser.evalDouble(this.node, expression);
    }

    public List<XNode> evalNodes(String expression) {
        return this.xpathParser.evalNodes(this.node, expression);
    }

    public XNode evalNode(String expression) {
        return this.xpathParser.evalNode(this.node, expression);
    }

    public Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.name;
    }

    public String getStringBody() {
        return this.getStringBody(null);
    }

    public String getStringBody(String def) {
        return this.body == null ? def : this.body;
    }

    public Boolean getBooleanBody() {
        return this.getBooleanBody(null);
    }

    public Boolean getBooleanBody(Boolean def) {
        return this.body == null ? def : Boolean.valueOf(this.body);
    }

    public Integer getIntBody() {
        return this.getIntBody(null);
    }

    public Integer getIntBody(Integer def) {
        return this.body == null ? def : Integer.valueOf(this.body);
    }

    public Long getLongBody() {
        return this.getLongBody(null);
    }

    public Long getLongBody(Long def) {
        return this.body == null ? def : Long.valueOf(this.body);
    }

    public Double getDoubleBody() {
        return this.getDoubleBody(null);
    }

    public Double getDoubleBody(Double def) {
        return this.body == null ? def : Double.valueOf(this.body);
    }

    public Float getFloatBody() {
        return this.getFloatBody(null);
    }

    public Float getFloatBody(Float def) {
        return this.body == null ? def : Float.valueOf(this.body);
    }

    public <T extends Enum<T>> T getEnumAttribute(Class<T> enumType, String name) {
        return this.getEnumAttribute(enumType, name, null);
    }

    public <T extends Enum<T>> T getEnumAttribute(Class<T> enumType, String name, T def) {
        String value = this.getStringAttribute(name);
        return value == null ? def : Enum.valueOf(enumType, value);
    }

    public String getStringAttribute(String name, Supplier<String> defSupplier) {
        String value = this.attributes.getProperty(name);
        return value == null ? defSupplier.get() : value;
    }

    public String getStringAttribute(String name) {
        return this.getStringAttribute(name, (String)null);
    }

    public String getStringAttribute(String name, String def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : value;
    }

    public Boolean getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, null);
    }

    public Boolean getBooleanAttribute(String name, Boolean def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Boolean.valueOf(value);
    }

    public Integer getIntAttribute(String name) {
        return this.getIntAttribute(name, null);
    }

    public Integer getIntAttribute(String name, Integer def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Integer.valueOf(value);
    }

    public Long getLongAttribute(String name) {
        return this.getLongAttribute(name, null);
    }

    public Long getLongAttribute(String name, Long def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Long.valueOf(value);
    }

    public Double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, null);
    }

    public Double getDoubleAttribute(String name, Double def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Double.valueOf(value);
    }

    public Float getFloatAttribute(String name) {
        return this.getFloatAttribute(name, null);
    }

    public Float getFloatAttribute(String name, Float def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Float.valueOf(value);
    }

    public List<XNode> getChildren() {
        ArrayList<XNode> children = new ArrayList<XNode>();
        NodeList nodeList = this.node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                children.add(new XNode(this.xpathParser, node, this.variables));
            }
        }
        return children;
    }

    public Properties getChildrenAsProperties() {
        Properties properties = new Properties();
        for (XNode child : this.getChildren()) {
            String name = child.getStringAttribute("name");
            String value = child.getStringAttribute("value");
            if (name == null || value == null) continue;
            properties.setProperty(name, value);
        }
        return properties;
    }

    public String toString() {
        return this.buildToString(new StringBuilder(), 0).toString();
    }

    private StringBuilder buildToString(StringBuilder builder, int indentLevel) {
        this.indent(builder, indentLevel).append("<").append(this.name);
        for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
            builder.append(" ");
            builder.append(entry.getKey());
            builder.append("=\"");
            builder.append(entry.getValue());
            builder.append("\"");
        }
        NodeList nodeList = this.node.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            builder.append(" />\n");
        } else {
            builder.append(">\n");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                short nodeType = node.getNodeType();
                if (nodeType == 1) {
                    new XNode(this.xpathParser, node, this.variables).buildToString(builder, indentLevel + 1);
                    continue;
                }
                String text = this.getBodyData(node).trim();
                if (text.length() <= 0) continue;
                this.indent(builder, indentLevel + 1).append(text).append("\n");
            }
            this.indent(builder, indentLevel).append("</").append(this.name).append(">\n");
        }
        return builder;
    }

    private StringBuilder indent(StringBuilder builder, int level) {
        for (int i = 0; i < level; ++i) {
            builder.append("  ");
        }
        return builder;
    }

    private Properties parseAttributes(Node n) {
        Properties attributes = new Properties();
        NamedNodeMap attributeNodes = n.getAttributes();
        if (attributeNodes != null) {
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                Node attribute = attributeNodes.item(i);
                String value = PropertyParser.parse(attribute.getNodeValue(), this.variables);
                attributes.put(attribute.getNodeName(), value);
            }
        }
        return attributes;
    }

    private String parseBody(Node node) {
        String data = this.getBodyData(node);
        if (data == null) {
            Node child;
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength() && (data = this.getBodyData(child = children.item(i))) == null; ++i) {
            }
        }
        return data;
    }

    private String getBodyData(Node child) {
        if (child.getNodeType() == 4 || child.getNodeType() == 3) {
            String data = ((CharacterData)child).getData();
            return PropertyParser.parse(data, this.variables);
        }
        return null;
    }
}

