/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoMap;
import io.vertx.core.Vertx;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.ClusterLease;
import org.apache.cassandra.sidecar.db.schema.SidecarInternalKeyspace;
import org.apache.cassandra.sidecar.db.schema.SidecarSchema;
import org.apache.cassandra.sidecar.db.schema.SidecarSchemaInitializer;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchemaFetcher;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.modules.multibindings.KeyClassMapKey;
import org.apache.cassandra.sidecar.modules.multibindings.MultiBindingTypeResolver;
import org.apache.cassandra.sidecar.modules.multibindings.PeriodicTaskMapKeys;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarSchemaModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarSchemaModule.class);

    @Provides
    @Singleton
    public SidecarSchema sidecarSchema(Vertx vertx, SidecarConfiguration configuration, MultiBindingTypeResolver<TableSchema> resolver) {
        SidecarInternalKeyspace sidecarInternalKeyspace = new SidecarInternalKeyspace(configuration);
        resolver.resolve().values().forEach(tableSchema -> {
            LOGGER.info("Registering table schema: {}", tableSchema);
            try {
                sidecarInternalKeyspace.registerTableSchema((TableSchema)tableSchema);
            }
            catch (Throwable cause) {
                throw new RuntimeException("Failed to register table schema: " + tableSchema, cause);
            }
        });
        return new SidecarSchema(vertx, configuration, sidecarInternalKeyspace);
    }

    @Provides
    @Singleton
    public TableSchemaFetcher tableSchemaFetcher(SidecarSchema sidecarSchema) {
        return sidecarSchema;
    }

    @ProvidesIntoMap
    @KeyClassMapKey(value=PeriodicTaskMapKeys.SidecarSchemaInitializerTaskKey.class)
    PeriodicTask sidecarSchemaInitializer(SidecarConfiguration configuration, CQLSessionProvider cqlSessionProvider, SidecarMetrics sidecarMetrics, SidecarSchema sidecarSchema, ClusterLease clusterLease) {
        return new SidecarSchemaInitializer(configuration, cqlSessionProvider, sidecarSchema.sidecarInternalKeyspace(), sidecarMetrics.server().schema(), clusterLease);
    }
}

