/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.cdc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.cdc.CdcLogCache;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.utils.HttpRange;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.models.HttpResponse;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.CdcUtil;
import org.apache.cassandra.sidecar.utils.FileStreamer;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StreamCdcSegmentHandler
extends AbstractHandler<String>
implements AccessProtected {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamCdcSegmentHandler.class);
    private final FileStreamer fileStreamer;
    private final CdcLogCache cdcLogCache;
    private final TaskExecutorPool serviceExecutorPool;

    @Inject
    public StreamCdcSegmentHandler(InstanceMetadataFetcher metadataFetcher, FileStreamer fileStreamer, CdcLogCache cdcLogCache, ExecutorPools executorPools, CassandraInputValidator validator) {
        super(metadataFetcher, executorPools, validator);
        this.fileStreamer = fileStreamer;
        this.cdcLogCache = cdcLogCache;
        this.serviceExecutorPool = executorPools.service();
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.CDC.toAuthorization());
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, String segment) {
        this.cdcLogCache.initMaybe();
        InstanceMetadata instance = this.metadataFetcher.instance(host);
        String cdcDir = instance.cdcDir();
        File segmentFile = new File(cdcDir, segment);
        this.validateCdcSegmentFile(segmentFile);
        String indexFileName = CdcUtil.getIdxFileName(segment);
        File indexFile = new File(cdcDir, indexFileName);
        HttpResponse response = new HttpResponse(context.request(), context.response());
        this.streamCdcSegmentAsync(context, segmentFile, indexFile, response, instance).onSuccess(res -> this.cdcLogCache.touch(segmentFile, indexFile)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, segment));
    }

    private Future<Void> streamCdcSegmentAsync(RoutingContext context, File segmentFile, File indexFile, HttpResponse response, InstanceMetadata instance) {
        long segmentFileLength = segmentFile.length();
        return this.getOrCreateLinkedCdcFilePairAsync(segmentFile, indexFile).compose(cdcFilePair -> this.openCdcIndexFileAsync((CdcFilePair)cdcFilePair).compose(cdcIndex -> {
            String rangeHeader = context.request().getHeader((CharSequence)HttpHeaderNames.RANGE);
            return cdcIndex.isCompleted ? this.fileStreamer.parseRangeHeader(rangeHeader, segmentFileLength) : this.fileStreamer.parseRangeHeader(rangeHeader, cdcIndex.latestFlushPosition);
        }).compose(range -> this.fileStreamer.stream(response, instance.id(), cdcFilePair.segmentFile.getAbsolutePath(), segmentFileLength, (HttpRange)range)));
    }

    @Override
    protected String extractParamsOrThrow(RoutingContext context) {
        return context.request().getParam("segment");
    }

    private void validateCdcSegmentFile(File segmentFile) throws HttpException {
        if (!CdcUtil.isValid(segmentFile.getName()) || !CdcUtil.isLogFile(segmentFile.getName())) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid path param for CDC segment: " + segmentFile.getName());
        }
        if (!segmentFile.exists()) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, "CDC segment not found: " + segmentFile.getName());
        }
        long fileSize = segmentFile.length();
        if (fileSize == 0L) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE, "File is empty");
        }
    }

    private Future<CdcFilePair> getOrCreateLinkedCdcFilePairAsync(File segmentFile, File indexFile) {
        return this.serviceExecutorPool.executeBlocking(() -> {
            try {
                File linkedSegmentFile = this.cdcLogCache.createLinkedFileInCache(segmentFile);
                File linkedIndexFile = this.cdcLogCache.createLinkedFileInCache(indexFile);
                return new CdcFilePair(linkedSegmentFile, linkedIndexFile);
            }
            catch (IOException e) {
                LOGGER.debug("Failed to prepare CDC segment to stream", (Throwable)e);
                throw HttpExceptions.wrapHttpException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Failed to prepare CDC segment to stream", e);
            }
        });
    }

    private Future<CdcUtil.CdcIndex> openCdcIndexFileAsync(CdcFilePair cdcFilePair) {
        return this.serviceExecutorPool.executeBlocking(() -> {
            try {
                return CdcUtil.parseIndexFile(cdcFilePair.indexFile, cdcFilePair.segmentFile.length());
            }
            catch (IOException e) {
                LOGGER.error("Failed to read CDC index file", (Throwable)e);
                throw HttpExceptions.wrapHttpException(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Failed to read CDC index file", e);
            }
        });
    }

    private static class CdcFilePair {
        private final File segmentFile;
        private final File indexFile;

        private CdcFilePair(File segmentFile, File indexFile) {
            this.segmentFile = segmentFile;
            this.indexFile = indexFile;
        }
    }
}

