/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.db.DatabaseAccessor;
import org.apache.cassandra.sidecar.db.schema.SystemViewsSchema;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.apache.cassandra.sidecar.exceptions.SchemaUnavailableException;
import org.apache.cassandra.sidecar.utils.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SystemViewsDatabaseAccessor
extends DatabaseAccessor<SystemViewsSchema> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemViewsDatabaseAccessor.class);
    private static final String YAML_PROP_IN_MB = "cdc_total_space_in_mb";
    private static final String YAML_PROP_WITH_UNIT = "cdc_total_space";

    @Inject
    public SystemViewsDatabaseAccessor(SystemViewsSchema systemViewsSchema, CQLSessionProvider sessionProvider) {
        super((TableSchema)systemViewsSchema, sessionProvider);
    }

    @Nullable
    public Long cdcTotalSpaceBytesSetting() throws SchemaUnavailableException {
        String[] cdcTotalSpaceSettingNames = new String[]{YAML_PROP_IN_MB, YAML_PROP_WITH_UNIT};
        Map<String, String> settings = this.getSettings(cdcTotalSpaceSettingNames);
        String cdcTotalSpaceInMb = settings.get(YAML_PROP_IN_MB);
        if (cdcTotalSpaceInMb != null) {
            return FileUtils.mbStringToBytes(cdcTotalSpaceInMb);
        }
        String storageStringToBytes = settings.get(YAML_PROP_WITH_UNIT);
        if (storageStringToBytes != null) {
            return FileUtils.storageStringToBytes(storageStringToBytes);
        }
        LOGGER.warn("Unable to determine the CDC total space value from setting names {}", (Object)cdcTotalSpaceSettingNames);
        return null;
    }

    @NotNull
    public Map<String, String> getSettings(String ... names) throws SchemaUnavailableException {
        BoundStatement statement = ((SystemViewsSchema)this.tableSchema).selectSettings().bind(new Object[]{Arrays.asList(names)});
        ResultSet result = this.execute((Statement)statement);
        return result.all().stream().collect(Collectors.toMap(row -> row.getString(0), row -> row.getString(1)));
    }
}

