/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.TableMetadata;
import com.linkedin.common.DataPlatformInstance;
import com.linkedin.common.urn.Urn;
import datahub.event.MetadataChangeProposalWrapper;
import java.net.URISyntaxException;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.apache.cassandra.sidecar.datahub.TableToAspectConverter;
import org.jetbrains.annotations.NotNull;

public class TableToDataPlatformInstanceConverter
extends TableToAspectConverter<DataPlatformInstance> {
    public TableToDataPlatformInstanceConverter(@NotNull IdentifiersProvider identifiers) {
        super(identifiers);
    }

    @Override
    @NotNull
    public MetadataChangeProposalWrapper<DataPlatformInstance> convert(@NotNull TableMetadata table) throws URISyntaxException {
        String urn = this.identifiers.urnDataset(table);
        DataPlatformInstance aspect = new DataPlatformInstance().setPlatform(new Urn(this.identifiers.urnDataPlatform())).setInstance(new Urn(this.identifiers.urnDataPlatformInstance()));
        return this.wrap(urn, aspect);
    }
}

