/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.TableMetadata;
import com.linkedin.common.BrowsePathEntry;
import com.linkedin.common.BrowsePathEntryArray;
import com.linkedin.common.BrowsePathsV2;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.SetMode;
import datahub.event.MetadataChangeProposalWrapper;
import java.net.URISyntaxException;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.apache.cassandra.sidecar.datahub.TableToAspectConverter;
import org.jetbrains.annotations.NotNull;

public class TableToBrowsePathsV2Converter
extends TableToAspectConverter<BrowsePathsV2> {
    public TableToBrowsePathsV2Converter(@NotNull IdentifiersProvider identifiers) {
        super(identifiers);
    }

    @Override
    @NotNull
    public MetadataChangeProposalWrapper<BrowsePathsV2> convert(@NotNull TableMetadata table) throws URISyntaxException {
        String urn = this.identifiers.urnDataset(table);
        String container = this.identifiers.urnContainer(table.getKeyspace());
        BrowsePathsV2 aspect = new BrowsePathsV2().setPath(new BrowsePathEntryArray(new BrowsePathEntry().setId(this.identifiers.environment()).setUrn(null, SetMode.REMOVE_IF_NULL), new BrowsePathEntry[]{new BrowsePathEntry().setId(this.identifiers.application()).setUrn(null, SetMode.REMOVE_IF_NULL), new BrowsePathEntry().setId(this.identifiers.cluster()).setUrn(null, SetMode.REMOVE_IF_NULL), new BrowsePathEntry().setId(container).setUrn(new Urn(container))}));
        return this.wrap(urn, aspect);
    }
}

