/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.JmxConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxConfigurationImpl
implements JmxConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxConfigurationImpl.class);
    @JsonProperty(value="max_retries")
    protected final int maxRetries;
    protected MillisecondBoundConfiguration retryDelay;

    public JmxConfigurationImpl() {
        this(3, MillisecondBoundConfiguration.parse((String)"200ms"));
    }

    public JmxConfigurationImpl(int maxRetries, MillisecondBoundConfiguration retryDelay) {
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
    }

    @Override
    @JsonProperty(value="max_retries")
    public int maxRetries() {
        return this.maxRetries;
    }

    @Override
    @JsonProperty(value="retry_delay")
    public MillisecondBoundConfiguration retryDelay() {
        return this.retryDelay;
    }

    @JsonProperty(value="retry_delay")
    public void setRetryDelay(MillisecondBoundConfiguration retryDelay) {
        this.retryDelay = retryDelay;
    }

    @JsonProperty(value="retry_delay_millis")
    @Deprecated
    public void setRetryDelayMillis(long retryDelayMillis) {
        LOGGER.warn("'retry_delay_millis' is deprecated, use 'retry_delay' instead");
        this.setRetryDelay(new MillisecondBoundConfiguration(retryDelayMillis, TimeUnit.MILLISECONDS));
    }
}

