/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.concurrent;

import com.codahale.metrics.Timer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.ThrowingRunnable;
import org.apache.cassandra.sidecar.config.WorkerPoolConfiguration;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.metrics.StopWatch;

public abstract class TaskExecutorPool
implements WorkerExecutor {
    private final Vertx vertx;
    private final WorkerExecutor workerExecutor;

    private TaskExecutorPool(Vertx vertx, WorkerPoolConfiguration config) {
        this.vertx = vertx;
        this.workerExecutor = vertx.createSharedWorkerExecutor(config.workerPoolName(), config.workerPoolSize(), config.workerMaxExecutionTime().quantity(), config.workerMaxExecutionTime().unit());
    }

    public long setPeriodic(long delay, Handler<Long> handler) {
        return this.setPeriodic(delay, handler, false);
    }

    public long setPeriodic(long delay, Handler<Long> handler, boolean ordered) {
        return this.setPeriodic(delay, delay, handler, ordered);
    }

    public long setPeriodic(long initialDelay, long delay, Handler<Long> handler) {
        return this.setPeriodic(initialDelay, delay, handler, false);
    }

    public long setPeriodic(long initialDelay, long delay, Handler<Long> handler, boolean ordered) {
        return this.vertx.setPeriodic(initialDelay, delay, id -> this.workerExecutor.executeBlocking(() -> {
            handler.handle(id);
            return id;
        }, ordered));
    }

    public long setTimer(long delay, Handler<Long> handler) {
        return this.setTimer(delay, handler, false);
    }

    public long setTimer(long delay, Handler<Long> handler, boolean ordered) {
        return this.vertx.setTimer(delay, id -> this.workerExecutor.executeBlocking(() -> {
            handler.handle(id);
            return id;
        }, ordered));
    }

    public boolean cancelTimer(long id) {
        return this.vertx.cancelTimer(id);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        throw new UnsupportedOperationException("Operation is unsupported!");
    }

    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        return StopWatch.measureTimeTaken(this.workerExecutor.executeBlocking(blockingCodeHandler, ordered), this::recordTimeTaken);
    }

    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return StopWatch.measureTimeTaken(this.workerExecutor.executeBlocking(blockingCodeHandler, ordered), this::recordTimeTaken);
    }

    public Future<Void> runBlocking(ThrowingRunnable runnable) {
        return this.runBlocking(runnable, false);
    }

    public Future<Void> runBlocking(ThrowingRunnable runnable, boolean ordered) {
        Callable<Void> callable = () -> {
            runnable.run();
            return null;
        };
        return this.executeBlocking(callable, ordered);
    }

    protected abstract void recordTimeTaken(long var1);

    public void close(Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException("Closing TaskExecutorPool is not supported!");
    }

    public Future<Void> close() {
        throw new UnsupportedOperationException("Closing TaskExecutorPool is not supported!");
    }

    Future<Void> closeInternal() {
        return this.workerExecutor.close();
    }

    static class InternalTaskExecutorPool
    extends TaskExecutorPool {
        private final SidecarMetrics metrics;

        InternalTaskExecutorPool(Vertx vertx, WorkerPoolConfiguration config, SidecarMetrics metrics) {
            super(vertx, config);
            this.metrics = metrics;
        }

        @Override
        protected void recordTimeTaken(long durationNanos) {
            if (this.metrics == null) {
                return;
            }
            ((Timer)this.metrics.server().resource().internalTaskTime.metric).update(durationNanos, TimeUnit.NANOSECONDS);
        }
    }

    static class ServiceTaskExecutorPool
    extends TaskExecutorPool {
        private final SidecarMetrics metrics;

        ServiceTaskExecutorPool(Vertx vertx, WorkerPoolConfiguration config, SidecarMetrics metrics) {
            super(vertx, config);
            this.metrics = metrics;
        }

        @Override
        protected void recordTimeTaken(long durationNanos) {
            if (this.metrics == null) {
                return;
            }
            ((Timer)this.metrics.server().resource().serviceTaskTime.metric).update(durationNanos, TimeUnit.NANOSECONDS);
        }
    }
}

