/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.cdc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import io.vertx.core.Handler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.utils.CdcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcLogCache {
    public static final String TEMP_DIR_SUFFIX = "_tmp";
    private static final Logger LOGGER = LoggerFactory.getLogger(CdcLogCache.class);
    private static final RemovalListener<File, File> hardlinkRemover = notification -> CdcLogCache.deleteFileIfExist((File)notification.getValue());
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private final TaskExecutorPool internalExecutorPool;
    private final SecondBoundConfiguration cacheExpiryConfig;
    @VisibleForTesting
    final Cache<File, File> hardlinkCache;

    public CdcLogCache(ExecutorPools executorPools, InstancesMetadata instancesMetadata, SidecarConfiguration sidecarConfig) {
        this(executorPools, instancesMetadata, sidecarConfig.serviceConfiguration().cdcConfiguration().segmentHardLinkCacheExpiry());
    }

    @VisibleForTesting
    CdcLogCache(ExecutorPools executorPools, InstancesMetadata instancesMetadata, SecondBoundConfiguration cacheExpiryConfig) {
        this.cacheExpiryConfig = cacheExpiryConfig;
        this.internalExecutorPool = executorPools.internal();
        this.hardlinkCache = CacheBuilder.newBuilder().expireAfterAccess(cacheExpiryConfig.quantity(), cacheExpiryConfig.unit()).removalListener(hardlinkRemover).build();
        this.internalExecutorPool.runBlocking(() -> this.cleanupLinkedFilesOnStartup(instancesMetadata));
    }

    public void initMaybe() {
        if (this.isInitialized.get()) {
            return;
        }
        if (this.isInitialized.compareAndSet(false, true)) {
            long cacheExpiryInMillis = this.cacheExpiryConfig.to(TimeUnit.MILLISECONDS);
            this.internalExecutorPool.setPeriodic(cacheExpiryInMillis, (Handler<Long>)((Handler)id -> this.hardlinkCache.cleanUp()), true);
        }
    }

    public void touch(File segmentFile, File indexFile) {
        this.hardlinkCache.getIfPresent((Object)segmentFile);
        this.hardlinkCache.getIfPresent((Object)indexFile);
    }

    public File createLinkedFileInCache(File origin) throws IOException {
        File link = (File)this.hardlinkCache.getIfPresent((Object)origin);
        if (link == null) {
            link = new File(CdcLogCache.getTempCdcDir(origin.getParent()), origin.getName());
            try {
                Files.createLink(link.toPath(), origin.toPath());
                this.hardlinkCache.put((Object)origin, (Object)link);
            }
            catch (FileAlreadyExistsException e) {
                LOGGER.debug("The target of hardlink {} already exists. It could be created by a concurrent request.", (Object)link);
            }
        }
        return link;
    }

    @VisibleForTesting
    public void cleanupLinkedFilesOnStartup(InstancesMetadata config) {
        for (InstanceMetadata instance : config.instances()) {
            try {
                this.cleanupLinkedFiles(instance);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to clean up linked files for instance {}", (Object)instance.id(), (Object)e);
            }
        }
    }

    private void cleanupLinkedFiles(InstanceMetadata instance) throws IOException {
        File[] files = CdcLogCache.getTempCdcDir(instance.cdcDir()).listFiles(f -> CdcUtil.isLogFile(f.getName()) || CdcUtil.isIndexFile(f.getName()));
        if (files == null) {
            return;
        }
        for (File f2 : files) {
            CdcLogCache.deleteFileIfExist(f2);
        }
    }

    private static void deleteFileIfExist(File file) {
        if (file.exists() && file.isFile() && file.delete()) {
            LOGGER.debug("Removed the link file={}", (Object)file);
        }
    }

    private static File getTempCdcDir(String cdcDir) throws IOException {
        File dir = new File(cdcDir + TEMP_DIR_SUFFIX);
        try {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Unable to create temporary CDC directory {}", (Object)dir, (Object)e);
            throw e;
        }
        return dir;
    }
}

