/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.ConcurrentNeighborSet;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.jctools.maps.NonBlockingHashMapLong;

public final class OnHeapGraphIndex<T>
implements GraphIndex<T>,
Accountable {
    private final AtomicLong entryPoint = new AtomicLong(-1L);
    private final NonBlockingHashMapLong<ConcurrentNeighborSet> nodes;
    final int nsize0;
    private final BiFunction<Integer, Integer, ConcurrentNeighborSet> neighborFactory;
    private static final float CHM_LOAD_FACTOR = 0.75f;

    OnHeapGraphIndex(int M, BiFunction<Integer, Integer, ConcurrentNeighborSet> neighborFactory) {
        this.neighborFactory = neighborFactory;
        this.nsize0 = 2 * M;
        this.nodes = new NonBlockingHashMapLong(1024);
    }

    public ConcurrentNeighborSet getNeighbors(int node) {
        return (ConcurrentNeighborSet)this.nodes.get((long)node);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    public void addNode(int node) {
        this.nodes.put((long)node, (Object)this.neighborFactory.apply(node, this.maxDegree()));
    }

    void markComplete(int node) {
        this.entryPoint.accumulateAndGet(node, (oldEntry, newEntry) -> {
            if (oldEntry >= 0L) {
                return oldEntry;
            }
            return newEntry;
        });
    }

    public void updateEntryNode(int node) {
        this.entryPoint.set(node);
    }

    @Override
    public int maxDegree() {
        return this.nsize0;
    }

    int entry() {
        return (int)this.entryPoint.get();
    }

    @Override
    public NodesIterator getNodes() {
        final PrimitiveIterator.OfLong keysInts = Arrays.stream(this.nodes.keySetLong()).iterator();
        return new NodesIterator(this.nodes.size()){

            @Override
            public int nextInt() {
                return keysInts.next().intValue();
            }

            @Override
            public boolean hasNext() {
                return keysInts.hasNext();
            }
        };
    }

    @Override
    public long ramBytesUsed() {
        long total = OnHeapGraphIndex.concurrentHashMapRamUsed(this.size());
        long chmSize = OnHeapGraphIndex.concurrentHashMapRamUsed(this.size());
        long neighborSize = OnHeapGraphIndex.neighborsRamUsed(this.maxDegree()) * (long)this.size();
        return total += chmSize + neighborSize;
    }

    public long ramBytesUsedOneNode(int nodeLevel) {
        int entryCount = (int)((float)nodeLevel / 0.75f);
        long graphBytesUsed = OnHeapGraphIndex.chmEntriesRamUsed(entryCount) + OnHeapGraphIndex.neighborsRamUsed(this.maxDegree()) + (long)nodeLevel * OnHeapGraphIndex.neighborsRamUsed(this.maxDegree());
        int clockBytesUsed = 4;
        return graphBytesUsed + (long)clockBytesUsed;
    }

    private static long neighborsRamUsed(int count) {
        long REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        long AH_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        long neighborSetBytes = REF_BYTES + 4L + 4L + REF_BYTES + AH_BYTES * 2L + REF_BYTES * 2L + 4L + 1L;
        return neighborSetBytes + (long)count * 8L;
    }

    private static long chmEntriesRamUsed(int internalEntryCount) {
        long REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        long chmNodeBytes = REF_BYTES + 3L * REF_BYTES + 4L;
        return (long)internalEntryCount * chmNodeBytes;
    }

    private static long concurrentHashMapRamUsed(int externalSize) {
        long REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        long AH_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        long CORES = Runtime.getRuntime().availableProcessors();
        long chmCounters = AH_BYTES + CORES * (REF_BYTES + 8L);
        int nodeCount = (int)((float)externalSize / 0.75f);
        long chmSize = OnHeapGraphIndex.chmEntriesRamUsed(nodeCount) + (long)nodeCount * REF_BYTES + AH_BYTES + 8L + 12L + 3L * REF_BYTES + chmCounters + REF_BYTES;
        return chmSize;
    }

    public String toString() {
        return String.format("OnHeapGraphIndex(size=%d, entryPoint=%d)", this.size(), this.entryPoint.get());
    }

    @Override
    public void close() {
    }

    @Override
    public GraphIndex.View<T> getView() {
        return new ConcurrentGraphIndexView();
    }

    void validateEntryNode() {
        if (this.size() == 0) {
            return;
        }
        long en = this.entryPoint.get();
        if (en < 0L || !this.nodes.containsKey(en)) {
            throw new IllegalStateException("Entry node was incompletely added! " + en);
        }
    }

    private class ConcurrentGraphIndexView
    implements GraphIndex.View<T> {
        private ConcurrentGraphIndexView() {
        }

        @Override
        public T getVector(int node) {
            throw new UnsupportedOperationException("All searches done with OnHeapGraphIndex should be exact");
        }

        @Override
        public NodesIterator getNeighborsIterator(int node) {
            return OnHeapGraphIndex.this.getNeighbors(node).iterator();
        }

        @Override
        public int size() {
            return OnHeapGraphIndex.this.size();
        }

        @Override
        public int entryNode() {
            return (int)OnHeapGraphIndex.this.entryPoint.get();
        }

        public String toString() {
            return "OnHeapGraphIndexView(size=" + this.size() + ", entryPoint=" + OnHeapGraphIndex.this.entryPoint.get();
        }

        @Override
        public void close() {
        }
    }
}

