/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Iterator;
import org.apache.cassandra.utils.caching.TinyThreadLocalPool;

public interface BulkIterator<V>
extends AutoCloseable {
    public void fetch(Object[] var1, int var2, int var3);

    public V next();

    @Override
    default public void close() {
    }

    public static <V> FromArray<V> of(Object[] from) {
        return BulkIterator.of(from, 0);
    }

    public static <V> FromArray<V> of(Object[] from, int offset) {
        TinyThreadLocalPool.TinyPool pool = (TinyThreadLocalPool.TinyPool)FromArray.POOL.get();
        FromArray result = (FromArray)pool.poll();
        if (result == null) {
            result = new FromArray();
        }
        result.init(from, offset);
        result.pool = pool;
        return result;
    }

    public static <V> Adapter<V> of(Iterator<V> from) {
        return new Adapter<V>(from);
    }

    public static class Adapter<V>
    implements BulkIterator<V> {
        final Iterator<V> adapt;

        private Adapter(Iterator<V> adapt) {
            this.adapt = adapt;
        }

        @Override
        public void fetch(Object[] into, int offset, int count) {
            count += offset;
            while (offset < count && this.adapt.hasNext()) {
                into[offset++] = this.adapt.next();
            }
        }

        public boolean hasNext() {
            return this.adapt.hasNext();
        }

        @Override
        public V next() {
            return this.adapt.next();
        }
    }

    public static class FromArray<V>
    implements BulkIterator<V>,
    AutoCloseable {
        private static final TinyThreadLocalPool<FromArray> POOL = new TinyThreadLocalPool();
        private Object[] from;
        private int i;
        private TinyThreadLocalPool.TinyPool<FromArray> pool;

        private void init(Object[] from, int offset) {
            this.from = from;
            this.i = offset;
        }

        @Override
        public void close() {
            this.pool.offer(this);
            this.from = null;
            this.pool = null;
        }

        @Override
        public void fetch(Object[] into, int offset, int count) {
            System.arraycopy(this.from, this.i, into, offset, count);
            this.i += count;
        }

        @Override
        public V next() {
            return (V)this.from[this.i++];
        }
    }
}

