/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="setstreamthroughput", description="Set throughput cap for streaming and entire SSTable streaming in the system, or 0 to disable throttling")
public class SetStreamThroughput
extends NodeTool.NodeToolCmd {
    @Arguments(title="stream_throughput", usage="<value_in_mb>", description="Value in megabits, 0 to disable throttling", required=true)
    private int streamThroughput;
    @Option(name={"-e", "--entire-sstable-throughput"}, description="Set entire SSTable streaming throughput in MiB/s")
    private boolean setEntireSSTableThroughput;
    @Option(name={"-m", "--mib"}, description="Set streaming throughput in MiB/s")
    private boolean streamThroughputInMebibytes;

    @Override
    public void execute(NodeProbe probe) {
        if (this.setEntireSSTableThroughput && this.streamThroughputInMebibytes) {
            throw new IllegalArgumentException("You cannot use -e and -m at the same time");
        }
        if (this.setEntireSSTableThroughput) {
            probe.setEntireSSTableStreamThroughput(this.streamThroughput);
        } else if (this.streamThroughputInMebibytes) {
            probe.setStreamThroughputMiB(this.streamThroughput);
        } else {
            probe.setStreamThroughput(this.streamThroughput);
        }
    }
}

