/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.RepairRetrySpec;
import org.apache.cassandra.config.RetrySpec;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.RepairMetrics;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageFlag;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.Backoff;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepairMessage {
    @VisibleForTesting
    static final CassandraVersion SUPPORTS_RETRY = new CassandraVersion("5.0.0-alpha2.SNAPSHOT");
    private static final Map<Verb, CassandraVersion> VERB_TIMEOUT_VERSIONS;
    public static final Set<Verb> ALLOWS_RETRY;
    private static final Set<Verb> SUPPORTS_RETRY_WITHOUT_VERSION_CHECK;
    public static final RequestCallback<Object> NOOP_CALLBACK;
    private static final Logger logger;
    private static final NoSpamLogger noSpam;
    @Nullable
    public final RepairJobDesc desc;

    protected RepairMessage(@Nullable RepairJobDesc desc) {
        this.desc = desc;
    }

    public TimeUUID parentRepairSession() {
        return this.desc.parentSessionId;
    }

    private static Backoff backoff(SharedContext ctx, Verb verb) {
        RetrySpec spec;
        RepairRetrySpec retrySpec = DatabaseDescriptor.getRepairRetrySpec();
        RetrySpec retrySpec2 = spec = verb == Verb.VALIDATION_RSP ? retrySpec.getMerkleTreeResponseSpec() : retrySpec;
        if (!spec.isEnabled()) {
            return Backoff.None.INSTANCE;
        }
        return new Backoff.ExponentialBackoff(spec.maxAttempts.value, spec.baseSleepTime.toMilliseconds(), spec.maxSleepTime.toMilliseconds(), ctx.random().get()::nextDouble);
    }

    public static Supplier<Boolean> notDone(Future<?> f) {
        return () -> !f.isDone();
    }

    public static Supplier<Boolean> always() {
        return () -> true;
    }

    public static <T> void sendMessageWithRetries(SharedContext ctx, Supplier<Boolean> allowRetry, RepairMessage request, Verb verb, InetAddressAndPort endpoint, RequestCallback<T> finalCallback) {
        RepairMessage.sendMessageWithRetries(ctx, RepairMessage.backoff(ctx, verb), allowRetry, request, verb, endpoint, finalCallback, 0);
    }

    public static <T> void sendMessageWithRetries(SharedContext ctx, RepairMessage request, Verb verb, InetAddressAndPort endpoint, RequestCallback<T> finalCallback) {
        RepairMessage.sendMessageWithRetries(ctx, RepairMessage.backoff(ctx, verb), RepairMessage.always(), request, verb, endpoint, finalCallback, 0);
    }

    public static void sendMessageWithRetries(SharedContext ctx, RepairMessage request, Verb verb, InetAddressAndPort endpoint) {
        RepairMessage.sendMessageWithRetries(ctx, RepairMessage.backoff(ctx, verb), RepairMessage.always(), request, verb, endpoint, NOOP_CALLBACK, 0);
    }

    public static void sendMessageWithRetries(SharedContext ctx, Supplier<Boolean> allowRetry, RepairMessage request, Verb verb, InetAddressAndPort endpoint) {
        RepairMessage.sendMessageWithRetries(ctx, RepairMessage.backoff(ctx, verb), allowRetry, request, verb, endpoint, NOOP_CALLBACK, 0);
    }

    @VisibleForTesting
    static <T> void sendMessageWithRetries(final SharedContext ctx, final Backoff backoff, final Supplier<Boolean> allowRetry, final RepairMessage request, final Verb verb, final InetAddressAndPort endpoint, final RequestCallback<T> finalCallback, final int attempt) {
        if (!ALLOWS_RETRY.contains((Object)verb)) {
            throw new AssertionError((Object)("Repair verb " + verb + " does not support retry, but a request to send with retry was given!"));
        }
        RequestCallback callback = new RequestCallback<T>(){

            @Override
            public void onResponse(Message<T> msg) {
                this.maybeRecordRetry(null);
                finalCallback.onResponse(msg);
            }

            @Override
            public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
                ErrorHandling allowed = RepairMessage.errorHandlingSupported(ctx, endpoint, verb, request.parentRepairSession());
                switch (allowed) {
                    case NONE: {
                        logger.error("[#{}] {} failed on {}: {}", new Object[]{request.parentRepairSession(), verb, from, failureReason});
                        return;
                    }
                    case TIMEOUT: {
                        finalCallback.onFailure(from, failureReason);
                        return;
                    }
                    case RETRY: {
                        int maxAttempts = backoff.maxAttempts();
                        if (failureReason == RequestFailureReason.TIMEOUT && attempt < maxAttempts && ((Boolean)allowRetry.get()).booleanValue()) {
                            ctx.optionalTasks().schedule(() -> 2.lambda$onFailure$0(ctx, backoff, (Supplier)allowRetry, request, verb, endpoint, finalCallback, attempt), backoff.computeWaitTime(attempt), backoff.unit());
                            return;
                        }
                        this.maybeRecordRetry(failureReason);
                        finalCallback.onFailure(from, failureReason);
                        return;
                    }
                }
                throw new AssertionError((Object)("Unknown error handler: " + allowed));
            }

            private void maybeRecordRetry(@Nullable RequestFailureReason reason) {
                if (attempt <= 0) {
                    return;
                }
                String prefix = PreviewKind.NONE.logPrefix(request.parentRepairSession());
                RepairMetrics.retry(verb, attempt);
                if (reason == null) {
                    noSpam.info("{} Retry of repair verb " + verb + " was successful after {} attempts", prefix, attempt);
                } else if (reason == RequestFailureReason.TIMEOUT) {
                    noSpam.warn("{} Timeout for repair verb " + verb + "; could not complete within {} attempts", prefix, attempt);
                    RepairMetrics.retryTimeout(verb);
                } else {
                    noSpam.warn("{} {} failure for repair verb " + verb + "; could not complete within {} attempts", new Object[]{prefix, reason, attempt});
                    RepairMetrics.retryFailure(verb);
                }
            }

            @Override
            public boolean invokeOnFailure() {
                return true;
            }

            private static /* synthetic */ void lambda$onFailure$0(SharedContext ctx2, Backoff backoff2, Supplier allowRetry2, RepairMessage request2, Verb verb2, InetAddressAndPort endpoint2, RequestCallback finalCallback2, int attempt2) {
                RepairMessage.sendMessageWithRetries(ctx2, backoff2, allowRetry2, request2, verb2, endpoint2, finalCallback2, attempt2 + 1);
            }
        };
        ctx.messaging().sendWithCallback(Message.outWithFlag(verb, request, MessageFlag.CALL_BACK_ON_FAILURE), endpoint, callback);
    }

    public static void sendMessageWithFailureCB(SharedContext ctx, Supplier<Boolean> allowRetry, final RepairMessage request, final Verb verb, final InetAddressAndPort endpoint, final RepairFailureCallback failureCallback) {
        RequestCallback<Object> callback = new RequestCallback<Object>(){

            @Override
            public void onResponse(Message<Object> msg) {
                logger.info("[#{}] {} received by {}", new Object[]{request.parentRepairSession(), verb, endpoint});
            }

            @Override
            public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
                failureCallback.onFailure(RepairException.error(request.desc, PreviewKind.NONE, String.format("Got %s failure from %s: %s", new Object[]{verb, from, failureReason})));
            }

            @Override
            public boolean invokeOnFailure() {
                return true;
            }
        };
        RepairMessage.sendMessageWithRetries(ctx, allowRetry, request, verb, endpoint, callback);
    }

    private static ErrorHandling errorHandlingSupported(SharedContext ctx, InetAddressAndPort from, Verb verb, TimeUUID parentSessionId) {
        if (SUPPORTS_RETRY_WITHOUT_VERSION_CHECK.contains((Object)verb)) {
            return ErrorHandling.RETRY;
        }
        CassandraVersion remoteVersion = ctx.gossiper().getReleaseVersion(from);
        if (remoteVersion == null) {
            if (VERB_TIMEOUT_VERSIONS.containsKey((Object)verb)) {
                logger.warn("[#{}] Not failing repair due to remote host {} not supporting repair message timeouts (version is unknown)", (Object)parentSessionId, (Object)from);
                return ErrorHandling.NONE;
            }
            return ErrorHandling.TIMEOUT;
        }
        if (remoteVersion.compareTo(SUPPORTS_RETRY) >= 0) {
            return ErrorHandling.RETRY;
        }
        CassandraVersion timeoutVersion = VERB_TIMEOUT_VERSIONS.get((Object)verb);
        if (timeoutVersion == null || remoteVersion.compareTo(timeoutVersion) >= 0) {
            return ErrorHandling.TIMEOUT;
        }
        return ErrorHandling.NONE;
    }

    public static void sendFailureResponse(SharedContext ctx, Message<?> respondTo) {
        Message<RequestFailureReason> reply = respondTo.failureResponse(RequestFailureReason.UNKNOWN);
        ctx.messaging().send(reply, respondTo.from());
    }

    public static void sendAck(SharedContext ctx, Message<? extends RepairMessage> message) {
        ctx.messaging().send(message.emptyResponse(), message.from());
    }

    static {
        SUPPORTS_RETRY_WITHOUT_VERSION_CHECK = Collections.unmodifiableSet(EnumSet.of(Verb.CLEANUP_MSG));
        NOOP_CALLBACK = new RequestCallback<Object>(){

            @Override
            public void onResponse(Message<Object> msg) {
            }

            @Override
            public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
            }
        };
        CassandraVersion timeoutVersion = new CassandraVersion("4.0.7-SNAPSHOT");
        EnumMap<Verb, CassandraVersion> map = new EnumMap<Verb, CassandraVersion>(Verb.class);
        map.put(Verb.VALIDATION_REQ, timeoutVersion);
        map.put(Verb.SYNC_REQ, timeoutVersion);
        map.put(Verb.VALIDATION_RSP, SUPPORTS_RETRY);
        map.put(Verb.SYNC_RSP, SUPPORTS_RETRY);
        map.put(Verb.PREPARE_CONSISTENT_REQ, SUPPORTS_RETRY);
        map.put(Verb.PREPARE_CONSISTENT_RSP, SUPPORTS_RETRY);
        map.put(Verb.FINALIZE_PROPOSE_MSG, SUPPORTS_RETRY);
        map.put(Verb.FINALIZE_PROMISE_MSG, SUPPORTS_RETRY);
        map.put(Verb.FINALIZE_COMMIT_MSG, SUPPORTS_RETRY);
        map.put(Verb.FAILED_SESSION_MSG, SUPPORTS_RETRY);
        VERB_TIMEOUT_VERSIONS = Collections.unmodifiableMap(map);
        EnumSet<Verb> allowsRetry = EnumSet.noneOf(Verb.class);
        allowsRetry.add(Verb.PREPARE_MSG);
        allowsRetry.add(Verb.VALIDATION_REQ);
        allowsRetry.add(Verb.VALIDATION_RSP);
        allowsRetry.add(Verb.SYNC_REQ);
        allowsRetry.add(Verb.SYNC_RSP);
        allowsRetry.add(Verb.SNAPSHOT_MSG);
        allowsRetry.add(Verb.CLEANUP_MSG);
        allowsRetry.add(Verb.PREPARE_CONSISTENT_REQ);
        allowsRetry.add(Verb.PREPARE_CONSISTENT_RSP);
        allowsRetry.add(Verb.FINALIZE_PROPOSE_MSG);
        allowsRetry.add(Verb.FINALIZE_PROMISE_MSG);
        allowsRetry.add(Verb.FINALIZE_COMMIT_MSG);
        allowsRetry.add(Verb.FAILED_SESSION_MSG);
        ALLOWS_RETRY = Collections.unmodifiableSet(allowsRetry);
        logger = LoggerFactory.getLogger(RepairMessage.class);
        noSpam = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    }

    public static interface RepairFailureCallback {
        public void onFailure(Exception var1);
    }

    private static enum ErrorHandling {
        NONE,
        TIMEOUT,
        RETRY;

    }
}

