/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.asymmetric.HostDifferences;
import org.apache.cassandra.utils.MerkleTrees;

public class DifferenceHolder {
    private final ImmutableMap<InetAddressAndPort, HostDifferences> differences;

    public DifferenceHolder(List<TreeResponse> trees) {
        ImmutableMap.Builder diffBuilder = ImmutableMap.builder();
        for (int i = 0; i < trees.size() - 1; ++i) {
            TreeResponse r1 = trees.get(i);
            HostDifferences hd = new HostDifferences();
            for (int j = i + 1; j < trees.size(); ++j) {
                TreeResponse r2 = trees.get(j);
                hd.add(r2.endpoint, MerkleTrees.difference(r1.trees, r2.trees));
            }
            r1.trees.release();
            diffBuilder.put((Object)r1.endpoint, (Object)hd);
        }
        trees.get((int)(trees.size() - 1)).trees.release();
        this.differences = diffBuilder.build();
    }

    @VisibleForTesting
    DifferenceHolder(Map<InetAddressAndPort, HostDifferences> differences) {
        ImmutableMap.Builder diffBuilder = ImmutableMap.builder();
        diffBuilder.putAll(differences);
        this.differences = diffBuilder.build();
    }

    public Set<InetAddressAndPort> keyHosts() {
        return this.differences.keySet();
    }

    public HostDifferences get(InetAddressAndPort hostWithDifference) {
        return (HostDifferences)this.differences.get((Object)hostWithDifference);
    }

    public String toString() {
        return "DifferenceHolder{differences=" + this.differences + "}";
    }

    public boolean hasDifferenceBetween(InetAddressAndPort node1, InetAddressAndPort node2, Range<Token> range) {
        HostDifferences diffsNode1 = (HostDifferences)this.differences.get((Object)node1);
        if (diffsNode1 != null && diffsNode1.hasDifferencesFor(node2, range)) {
            return true;
        }
        HostDifferences diffsNode2 = (HostDifferences)this.differences.get((Object)node2);
        return diffsNode2 != null && diffsNode2.hasDifferencesFor(node1, range);
    }
}

