/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.cassandra.utils.memory.BufferPools;

public class ShareableBytes {
    private final ByteBuffer bytes;
    private final ShareableBytes owner;
    private volatile int count;
    private static final int UNSHARED = -1;
    private static final int RELEASED = 0;
    private static final AtomicIntegerFieldUpdater<ShareableBytes> countUpdater = AtomicIntegerFieldUpdater.newUpdater(ShareableBytes.class, "count");

    private ShareableBytes(ByteBuffer bytes) {
        this.count = -1;
        this.owner = this;
        this.bytes = bytes;
    }

    private ShareableBytes(ShareableBytes owner, ByteBuffer bytes) {
        this.owner = owner;
        this.bytes = bytes;
    }

    public ByteBuffer get() {
        assert (this.owner.count != 0);
        return this.bytes;
    }

    public boolean hasRemaining() {
        return this.bytes.hasRemaining();
    }

    public int remaining() {
        return this.bytes.remaining();
    }

    void skipBytes(int skipBytes) {
        this.bytes.position(this.bytes.position() + skipBytes);
    }

    void consume() {
        this.bytes.position(this.bytes.limit());
    }

    public ShareableBytes share() {
        int count = this.owner.count;
        if (count < 0) {
            this.owner.count = -count;
        }
        return this;
    }

    private ShareableBytes retain() {
        this.owner.doRetain();
        return this;
    }

    private void doRetain() {
        int count = this.count;
        if (count < 0) {
            countUpdater.lazySet(this, count - 1);
            return;
        }
        while (true) {
            if (count == 0) {
                throw new IllegalStateException("Attempted to reference an already released SharedByteBuffer");
            }
            if (countUpdater.compareAndSet(this, count, count + 1)) {
                return;
            }
            count = this.count;
        }
    }

    public void release() {
        this.owner.doRelease();
    }

    private void doRelease() {
        int count = this.count;
        if (count < 0) {
            countUpdater.lazySet(this, ++count);
        } else if (count > 0) {
            count = countUpdater.decrementAndGet(this);
        } else {
            throw new IllegalStateException("Already released");
        }
        if (count == 0) {
            BufferPools.forNetworking().put(this.bytes);
        }
    }

    boolean isReleased() {
        return this.owner.count == 0;
    }

    public ShareableBytes sliceAndConsume(int length) {
        int begin = this.bytes.position();
        int end = begin + length;
        ShareableBytes result = this.slice(begin, end);
        this.bytes.position(end);
        return result;
    }

    ShareableBytes slice(int begin, int end) {
        ByteBuffer slice = this.bytes.duplicate();
        slice.position(begin).limit(end);
        return new ShareableBytes(this.owner.retain(), slice);
    }

    public static ShareableBytes wrap(ByteBuffer buffer) {
        return new ShareableBytes(buffer);
    }
}

