/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.utils.memory.BufferPool;
import org.apache.cassandra.utils.memory.BufferPools;

public abstract class BufferPoolAllocator
extends AbstractByteBufAllocator {
    private static final BufferPool bufferPool = BufferPools.forNetworking();

    BufferPoolAllocator() {
        super(true);
    }

    public boolean isDirectBufferPooled() {
        return true;
    }

    protected ByteBuf newHeapBuffer(int minCapacity, int maxCapacity) {
        return Unpooled.buffer((int)minCapacity, (int)maxCapacity);
    }

    protected ByteBuf newDirectBuffer(int minCapacity, int maxCapacity) {
        Wrapped result = new Wrapped(this, this.getAtLeast(minCapacity), maxCapacity);
        result.clear();
        return result;
    }

    ByteBuffer get(int size) {
        return bufferPool.get(size, BufferType.OFF_HEAP);
    }

    ByteBuffer getAtLeast(int size) {
        return bufferPool.getAtLeast(size, BufferType.OFF_HEAP);
    }

    void put(ByteBuffer buffer) {
        bufferPool.put(buffer);
    }

    void putUnusedPortion(ByteBuffer buffer) {
        bufferPool.putUnusedPortion(buffer);
    }

    @VisibleForTesting
    public long usedSizeInBytes() {
        return bufferPool.usedSizeInBytes();
    }

    void release() {
    }

    public static class Wrapped
    extends UnpooledUnsafeDirectByteBuf {
        private ByteBuffer wrapped;

        Wrapped(BufferPoolAllocator allocator, ByteBuffer wrap, int maxCapacity) {
            super((ByteBufAllocator)allocator, wrap, Integer.max(wrap.capacity(), maxCapacity));
            this.wrapped = wrap;
        }

        public ByteBuf capacity(int newCapacity) {
            if (newCapacity == this.capacity()) {
                return this;
            }
            ByteBuf newBuffer = super.capacity(newCapacity);
            ByteBuffer nioBuffer = newBuffer.nioBuffer(0, newBuffer.capacity());
            bufferPool.put(this.wrapped);
            this.wrapped = nioBuffer;
            return newBuffer;
        }

        protected ByteBuffer allocateDirect(int initialCapacity) {
            return bufferPool.getAtLeast(initialCapacity, BufferType.OFF_HEAP);
        }

        protected void freeDirect(ByteBuffer buffer) {
        }

        public void deallocate() {
            super.deallocate();
            if (this.wrapped != null) {
                bufferPool.put(this.wrapped);
            }
        }

        public ByteBuffer adopt() {
            if (this.refCnt() > 1) {
                throw new IllegalStateException();
            }
            ByteBuffer adopt = this.wrapped;
            adopt.position(this.readerIndex()).limit(this.writerIndex());
            this.wrapped = null;
            return adopt;
        }
    }
}

