/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.keycache;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.keycache.KeyCache;
import org.apache.cassandra.io.util.DataInputPlus;

public interface KeyCacheSupport<T extends SSTableReader> {
    @Nonnull
    public KeyCache getKeyCache();

    @Nullable
    public ClusteringBound<?> getLowerBoundPrefixFromCache(DecoratedKey var1, boolean var2);

    @Nonnull
    default public KeyCacheKey getCacheKey(ByteBuffer key) {
        SSTableReader reader = (SSTableReader)((Object)this);
        return new KeyCacheKey(reader.metadata(), reader.descriptor, key);
    }

    @Nonnull
    default public KeyCacheKey getCacheKey(DecoratedKey key) {
        return this.getCacheKey(key.getKey());
    }

    @Nullable
    default public AbstractRowIndexEntry getCachedPosition(DecoratedKey key, boolean updateStats) {
        return this.getCachedPosition(this.getCacheKey(key), updateStats);
    }

    @Nullable
    default public AbstractRowIndexEntry getCachedPosition(KeyCacheKey key, boolean updateStats) {
        KeyCache keyCache = this.getKeyCache();
        AbstractRowIndexEntry cachedEntry = keyCache.get(key, updateStats);
        if (!1.$assertionsDisabled && cachedEntry != null && cachedEntry.getSSTableFormat() != ((SSTableReader)((Object)this)).descriptor.version.format) {
            throw new AssertionError();
        }
        return cachedEntry;
    }

    default public void cacheKey(@Nonnull DecoratedKey key, @Nonnull AbstractRowIndexEntry info) {
        SSTableReader reader = (SSTableReader)((Object)this);
        if (!1.$assertionsDisabled && info.getSSTableFormat() != reader.descriptor.version.format) {
            throw new AssertionError();
        }
        KeyCacheKey cacheKey = this.getCacheKey(key);
        this.getKeyCache().put(cacheKey, info);
    }

    @Nonnull
    public AbstractRowIndexEntry deserializeKeyCacheValue(@Nonnull DataInputPlus var1) throws IOException;

    public static boolean isSupportedBy(SSTableFormat<?, ?> format) {
        return KeyCacheSupport.class.isAssignableFrom(format.getReaderFactory().getReaderClass());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

