/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.AbstractRowIndexEntry;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.SSTableZeroCopyWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.StatsComponent;
import org.apache.cassandra.io.sstable.format.TOCComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.MmappedRegionsCache;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTableWriter
extends SSTable
implements Transactional {
    private static final Logger logger = LoggerFactory.getLogger(SSTableWriter.class);
    protected long repairedAt;
    protected TimeUUID pendingRepair;
    protected boolean isTransient;
    protected long maxDataAge = -1L;
    protected final long keyCount;
    protected final MetadataCollector metadataCollector;
    protected final SerializationHeader header;
    protected final List<SSTableFlushObserver> observers;
    protected final MmappedRegionsCache mmappedRegionsCache;
    protected final TransactionalProxy txnProxy = this.txnProxy();
    protected final LifecycleNewTracker lifecycleNewTracker;
    protected DecoratedKey first;
    protected DecoratedKey last;

    protected abstract TransactionalProxy txnProxy();

    protected SSTableWriter(Builder<?, ?> builder, LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
        super(builder, owner);
        Preconditions.checkNotNull(builder.getIndexGroups());
        Preconditions.checkNotNull((Object)builder.getMetadataCollector());
        Preconditions.checkNotNull((Object)builder.getSerializationHeader());
        this.keyCount = builder.getKeyCount();
        this.repairedAt = builder.getRepairedAt();
        this.pendingRepair = builder.getPendingRepair();
        this.isTransient = builder.isTransientSSTable();
        this.metadataCollector = builder.getMetadataCollector();
        this.header = builder.getSerializationHeader();
        this.mmappedRegionsCache = builder.getMmappedRegionsCache();
        this.lifecycleNewTracker = lifecycleNewTracker;
        Set existingComponents = Sets.filter((Set)this.components, c -> this.descriptor.fileFor((Component)c).exists());
        assert (existingComponents.isEmpty()) : String.format("Cannot create a new SSTable in directory %s as component files %s already exist there", this.descriptor.directory, existingComponents);
        lifecycleNewTracker.trackNew(this);
        try {
            ArrayList<SSTableFlushObserver> observers = new ArrayList<SSTableFlushObserver>();
            this.observers = Collections.unmodifiableList(observers);
            for (Index.Group group : builder.getIndexGroups()) {
                SSTableFlushObserver observer = group.getFlushObserver(this.descriptor, lifecycleNewTracker, this.metadata.getLocal());
                if (observer == null) continue;
                observer.begin();
                observers.add(observer);
            }
        }
        catch (IOError | RuntimeException ex) {
            this.handleConstructionFailure(ex);
            throw ex;
        }
    }

    protected void handleConstructionFailure(Throwable ex) {
        logger.warn("Failed to open " + this.descriptor + " for writing", ex);
        for (int i = this.observers.size() - 1; i >= 0; --i) {
            this.observers.get(i).abort(ex);
        }
        this.descriptor.getFormat().deleteOrphanedComponents(this.descriptor, this.components);
        this.lifecycleNewTracker.untrackNew(this);
    }

    @Override
    public DecoratedKey getFirst() {
        return this.first;
    }

    @Override
    public DecoratedKey getLast() {
        return this.last;
    }

    @Override
    public AbstractBounds<Token> getBounds() {
        return this.first != null && this.last != null ? AbstractBounds.bounds(this.first.getToken(), true, this.last.getToken(), true) : null;
    }

    public abstract void mark();

    public abstract AbstractRowIndexEntry append(UnfilteredRowIterator var1);

    public abstract long getFilePointer();

    public abstract long getOnDiskFilePointer();

    public long getEstimatedOnDiskBytesWritten() {
        return this.getOnDiskFilePointer();
    }

    public abstract void resetAndTruncate();

    public void setRepairedAt(long repairedAt) {
        if (repairedAt > 0L) {
            this.repairedAt = repairedAt;
        }
    }

    public void setMaxDataAge(long maxDataAge) {
        this.maxDataAge = maxDataAge;
    }

    public SSTableWriter setTokenSpaceCoverage(double rangeSpanned) {
        this.metadataCollector.tokenSpaceCoverage(rangeSpanned);
        return this;
    }

    public void setOpenResult(boolean openResult) {
        this.txnProxy.openResult = openResult;
    }

    public abstract void openEarly(Consumer<SSTableReader> var1);

    public abstract SSTableReader openFinalEarly();

    protected abstract SSTableReader openFinal(SSTableReader.OpenReason var1);

    public SSTableReader finish(boolean openResult) {
        this.setOpenResult(openResult);
        this.observers.forEach(SSTableFlushObserver::complete);
        this.txnProxy.finish();
        return this.finished();
    }

    public SSTableReader finished() {
        this.txnProxy.finalReaderAccessed = true;
        return this.txnProxy.finalReader;
    }

    @Override
    public final void prepareToCommit() {
        this.txnProxy.prepareToCommit();
    }

    @Override
    public final Throwable commit(Throwable accumulate) {
        try {
            this.observers.forEach(SSTableFlushObserver::complete);
        }
        catch (Throwable t) {
            return Throwables.merge(accumulate, t);
        }
        return this.txnProxy.commit(accumulate);
    }

    @Override
    public final Throwable abort(Throwable accumulate) {
        try {
            Throwable throwable = this.txnProxy.abort(accumulate);
            return throwable;
        }
        finally {
            this.observers.forEach(observer -> observer.abort(accumulate));
        }
    }

    @Override
    public final void close() {
        this.txnProxy.close();
    }

    public final void abort() {
        try {
            this.txnProxy.abort();
        }
        finally {
            this.observers.forEach(observer -> observer.abort(null));
        }
    }

    protected Map<MetadataType, MetadataComponent> finalizeMetadata() {
        return this.metadataCollector.finalizeMetadata(this.getPartitioner().getClass().getCanonicalName(), this.metadata().params.bloomFilterFpChance, this.repairedAt, this.pendingRepair, this.isTransient, this.header, this.first.retainable().getKey(), this.last.retainable().getKey());
    }

    protected StatsMetadata statsMetadata() {
        return (StatsMetadata)this.finalizeMetadata().get((Object)MetadataType.STATS);
    }

    public void releaseMetadataOverhead() {
        this.metadataCollector.release();
    }

    public static abstract class Builder<W extends SSTableWriter, B extends Builder<W, B>>
    extends SSTable.Builder<W, B> {
        private MetadataCollector metadataCollector;
        private long keyCount;
        private long repairedAt;
        private TimeUUID pendingRepair;
        private boolean transientSSTable;
        private SerializationHeader serializationHeader;
        private List<Index.Group> indexGroups;

        public B setMetadataCollector(MetadataCollector metadataCollector) {
            this.metadataCollector = metadataCollector;
            return (B)this;
        }

        public B setKeyCount(long keyCount) {
            this.keyCount = keyCount;
            return (B)this;
        }

        public B setRepairedAt(long repairedAt) {
            this.repairedAt = repairedAt;
            return (B)this;
        }

        public B setPendingRepair(TimeUUID pendingRepair) {
            this.pendingRepair = pendingRepair;
            return (B)this;
        }

        public B setTransientSSTable(boolean transientSSTable) {
            this.transientSSTable = transientSSTable;
            return (B)this;
        }

        public B setSerializationHeader(SerializationHeader serializationHeader) {
            this.serializationHeader = serializationHeader;
            return (B)this;
        }

        public B addDefaultComponents(Collection<Index.Group> indexGroups) {
            Preconditions.checkNotNull((Object)this.getTableMetadataRef());
            this.addComponents((Collection<Component>)ImmutableSet.of((Object)SSTableFormat.Components.DATA, (Object)SSTableFormat.Components.STATS, (Object)SSTableFormat.Components.DIGEST, (Object)SSTableFormat.Components.TOC));
            if (this.getTableMetadataRef().getLocal().params.compression.isEnabled()) {
                this.addComponents((Collection<Component>)ImmutableSet.of((Object)SSTableFormat.Components.COMPRESSION_INFO));
            } else {
                this.addComponents((Collection<Component>)ImmutableSet.of((Object)SSTableFormat.Components.CRC));
            }
            if (!indexGroups.isEmpty()) {
                this.addComponents(Builder.indexComponents(indexGroups));
            }
            return (B)this;
        }

        private static Set<Component> indexComponents(Collection<Index.Group> indexGroups) {
            HashSet<Component> components = new HashSet<Component>();
            for (Index.Group group : indexGroups) {
                components.addAll(group.getComponents());
            }
            return components;
        }

        public B setSecondaryIndexGroups(Collection<Index.Group> indexGroups) {
            Preconditions.checkNotNull(indexGroups);
            this.indexGroups = ImmutableList.copyOf(indexGroups);
            return (B)this;
        }

        public MetadataCollector getMetadataCollector() {
            return this.metadataCollector;
        }

        public long getKeyCount() {
            return this.keyCount;
        }

        public long getRepairedAt() {
            return this.repairedAt;
        }

        public TimeUUID getPendingRepair() {
            return this.pendingRepair;
        }

        public boolean isTransientSSTable() {
            return this.transientSSTable;
        }

        public SerializationHeader getSerializationHeader() {
            return this.serializationHeader;
        }

        public List<Index.Group> getIndexGroups() {
            return this.indexGroups == null ? Collections.emptyList() : this.indexGroups;
        }

        public abstract MmappedRegionsCache getMmappedRegionsCache();

        public Builder(Descriptor descriptor) {
            super(descriptor);
        }

        public W build(LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
            Preconditions.checkNotNull(this.getComponents());
            SSTable.validateRepairedMetadata(this.getRepairedAt(), this.getPendingRepair(), this.isTransientSSTable());
            return this.buildInternal(lifecycleNewTracker, owner);
        }

        protected abstract W buildInternal(LifecycleNewTracker var1, SSTable.Owner var2);

        public SSTableZeroCopyWriter createZeroCopyWriter(LifecycleNewTracker lifecycleNewTracker, SSTable.Owner owner) {
            return new SSTableZeroCopyWriter(this, lifecycleNewTracker, owner);
        }
    }

    protected class TransactionalProxy
    extends Transactional.AbstractTransactional {
        private final Supplier<ImmutableList<Transactional>> transactionals;
        private SSTableReader finalReader;
        private boolean openResult;
        private boolean finalReaderAccessed;

        public TransactionalProxy(Supplier<ImmutableList<Transactional>> transactionals) {
            this.transactionals = transactionals;
        }

        @Override
        protected void doPrepare() {
            this.transactionals.get().forEach(Transactional::prepareToCommit);
            new StatsComponent(SSTableWriter.this.finalizeMetadata()).save(SSTableWriter.this.descriptor);
            TOCComponent.appendTOC(SSTableWriter.this.descriptor, SSTableWriter.this.components);
            if (this.openResult) {
                this.finalReader = SSTableWriter.this.openFinal(SSTableReader.OpenReason.NORMAL);
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            for (Transactional t : this.transactionals.get().reverse()) {
                accumulate = t.commit(accumulate);
            }
            return accumulate;
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            for (Transactional t : this.transactionals.get()) {
                accumulate = t.abort(accumulate);
            }
            if (!this.finalReaderAccessed && this.finalReader != null) {
                accumulate = Throwables.perform(accumulate, () -> this.finalReader.selfRef().release());
                this.finalReader = null;
                this.finalReaderAccessed = false;
            }
            return accumulate;
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            accumulate = super.doPostCleanup(accumulate);
            accumulate = Throwables.close(accumulate, SSTableWriter.this.mmappedRegionsCache);
            return accumulate;
        }
    }

    public static interface SSTableSizeParameters {
        public long partitionCount();

        public long partitionKeysSize();

        public long dataSize();
    }
}

