/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class NamedMemoryLimiter {
    private static final Logger logger = LoggerFactory.getLogger(NamedMemoryLimiter.class);
    private final AtomicLong bytesUsed = new AtomicLong(0L);
    private final String scope;
    private long limitBytes;

    public NamedMemoryLimiter(long limitBytes, String scope) {
        this.limitBytes = limitBytes;
        this.scope = scope;
        logger.info("[{}]: Memory limiter using limit of {}...", (Object)scope, (Object)FBUtilities.prettyPrintMemory(limitBytes));
    }

    public boolean usageExceedsLimit() {
        return this.currentBytesUsed() > this.limitBytes;
    }

    public long increment(long bytes) {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}]: Incrementing tracked memory usage by {} bytes from current usage of {}...", new Object[]{this.scope, bytes, this.currentBytesUsed()});
        }
        return this.bytesUsed.addAndGet(bytes);
    }

    public long decrement(long bytes) {
        if (logger.isTraceEnabled()) {
            logger.trace("[{}]: Decrementing tracked memory usage by {} bytes from current usage of {}...", new Object[]{this.scope, bytes, this.currentBytesUsed()});
        }
        return this.bytesUsed.addAndGet(-bytes);
    }

    public long currentBytesUsed() {
        return this.bytesUsed.get();
    }

    public long limitBytes() {
        return this.limitBytes;
    }

    @VisibleForTesting
    public void setLimitBytes(long bytes) {
        this.limitBytes = bytes;
    }
}

