/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.ResettableByteBuffersIndexOutput;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;

@NotThreadSafe
public class MetadataWriter
implements Closeable {
    private final IndexOutput output;
    private final Map<String, BytesRef> map = new HashMap<String, BytesRef>();

    public MetadataWriter(IndexOutput output) {
        this.output = output;
    }

    public Builder builder(String name) {
        return new Builder(name);
    }

    private void finish() throws IOException {
        SAICodecUtils.writeHeader(this.output);
        this.output.writeInt(this.map.size());
        for (Map.Entry<String, BytesRef> entry : this.map.entrySet()) {
            this.output.writeString(entry.getKey());
            this.output.writeInt(entry.getValue().length);
            this.output.writeBytes(entry.getValue().bytes, entry.getValue().offset, entry.getValue().length);
        }
        SAICodecUtils.writeFooter(this.output);
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.output.close();
        }
    }

    public class Builder
    extends ResettableByteBuffersIndexOutput
    implements Closeable {
        private Builder(String name) {
            super(name);
        }

        @Override
        public void close() {
            MetadataWriter.this.map.put(this.getName(), new BytesRef(this.toArrayCopy(), 0, this.intSize()));
        }
    }
}

