/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexStatusManager {
    private static final Logger logger = LoggerFactory.getLogger(IndexStatusManager.class);
    public static final IndexStatusManager instance = new IndexStatusManager();
    private final ExecutorPlus statusPropagationExecutor = ExecutorFactory.Global.executorFactory().withJmxInternal().sequential("StatusPropagationExecutor");
    public final Map<InetAddressAndPort, Map<String, Index.Status>> peerIndexStatus = new HashMap<InetAddressAndPort, Map<String, Index.Status>>();

    private IndexStatusManager() {
    }

    public <E extends Endpoints<E>> E filterForQuery(E liveEndpoints, Keyspace keyspace, Index.QueryPlan indexQueryPlan, ConsistencyLevel level) {
        int required;
        int filtered;
        int initial;
        HashSet queryableNonSucceeded = new HashSet(4);
        Endpoints queryableEndpoints = (Endpoints)liveEndpoints.filter(replica -> {
            boolean allBuilt = true;
            for (Index index : indexQueryPlan.getIndexes()) {
                Index.Status status;
                if (!index.isQueryable(status = this.getIndexStatus(replica.endpoint(), keyspace.getName(), index.getIndexMetadata().name))) {
                    return false;
                }
                if (status == Index.Status.BUILD_SUCCEEDED) continue;
                allBuilt = false;
            }
            if (!allBuilt) {
                queryableNonSucceeded.add(replica);
            }
            return true;
        });
        if (!queryableNonSucceeded.isEmpty() && queryableNonSucceeded.size() != queryableEndpoints.size()) {
            queryableEndpoints = (Endpoints)queryableEndpoints.sorted(Comparator.comparingInt(e -> queryableNonSucceeded.contains(e) ? 1 : -1));
        }
        if ((initial = liveEndpoints.size()) != (filtered = queryableEndpoints.size()) && (required = level.blockFor(keyspace.getReplicationStrategy())) <= initial && required > filtered) {
            HashMap<InetAddressAndPort, RequestFailureReason> failureReasons = new HashMap<InetAddressAndPort, RequestFailureReason>();
            ((AbstractReplicaCollection)liveEndpoints.without(queryableEndpoints.endpoints())).forEach((Consumer<? super Replica>)((Consumer<Replica>)replica -> failureReasons.put(replica.endpoint(), RequestFailureReason.INDEX_NOT_AVAILABLE)));
            throw new ReadFailureException(level, filtered, required, false, failureReasons);
        }
        return (E)queryableEndpoints;
    }

    public synchronized void receivePeerIndexStatus(InetAddressAndPort endpoint, VersionedValue versionedValue) {
        try {
            if (versionedValue == null) {
                return;
            }
            if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
                return;
            }
            Map<String, Index.Status> indexStatusMap = this.statusMapFromString(versionedValue);
            Map<String, Index.Status> oldStatus = this.peerIndexStatus.put(endpoint, indexStatusMap);
            Map<String, Index.Status> updated = this.updatedIndexStatuses(oldStatus, indexStatusMap);
            Set<String> removed = this.removedIndexStatuses(oldStatus, indexStatusMap);
            if (!updated.isEmpty() || !removed.isEmpty()) {
                logger.debug("Received index status for peer {}:\n    Updated: {}\n    Removed: {}", new Object[]{endpoint, updated, removed});
            }
        }
        catch (Exception e) {
            logger.error("Unable to parse index status: {}", (Object)e.getMessage());
        }
    }

    private Map<String, Index.Status> statusMapFromString(VersionedValue versionedValue) {
        Map peerStatus = JsonUtils.fromJsonMap(versionedValue.value);
        HashMap<String, Index.Status> indexStatusMap = new HashMap<String, Index.Status>();
        for (Map.Entry endpointStatus : peerStatus.entrySet()) {
            String keyspaceOrIndex = endpointStatus.getKey();
            Object keyspaceOrIndexStatus = endpointStatus.getValue();
            if (keyspaceOrIndexStatus instanceof String) {
                Index.Status status = Index.Status.valueOf(keyspaceOrIndexStatus.toString());
                indexStatusMap.put(keyspaceOrIndex, status);
                continue;
            }
            if (keyspaceOrIndexStatus instanceof Map) {
                Map keyspaceIndexStatusMap = (Map)keyspaceOrIndexStatus;
                for (Map.Entry indexStatus : keyspaceIndexStatusMap.entrySet()) {
                    Index.Status status = Index.Status.fromCode((Integer)indexStatus.getValue());
                    indexStatusMap.put(this.identifier(keyspaceOrIndex, (String)indexStatus.getKey()), status);
                }
                continue;
            }
            throw new MarshalException("Invalid index status format: " + endpointStatus);
        }
        return indexStatusMap;
    }

    public synchronized void propagateLocalIndexStatus(String keyspace, String index, Index.Status status) {
        try {
            Map statusMap = this.peerIndexStatus.computeIfAbsent(FBUtilities.getBroadcastAddressAndPort(), k -> new HashMap());
            String keyspaceIndex = this.identifier(keyspace, index);
            if (status == Index.Status.DROPPED) {
                statusMap.remove(keyspaceIndex);
            } else {
                statusMap.put(keyspaceIndex, status);
            }
            if (Gossiper.instance.isEnabled()) {
                CassandraVersion minVersion = Gossiper.instance.getMinVersion(1L, TimeUnit.SECONDS);
                String newSerializedStatusMap = IndexStatusManager.shouldWriteLegacyStatusFormat(minVersion) ? JsonUtils.writeAsJsonString(statusMap) : IndexStatusManager.toSerializedFormat(statusMap);
                this.statusPropagationExecutor.submit(() -> {
                    VersionedValue value = StorageService.instance.valueFactory.indexStatus(newSerializedStatusMap);
                    Gossiper.instance.addLocalApplicationState(ApplicationState.INDEX_STATUS, value);
                });
            }
        }
        catch (Exception e) {
            logger.warn("Unable to propagate index status: {}", (Object)e.getMessage());
        }
    }

    private static boolean shouldWriteLegacyStatusFormat(CassandraVersion minVersion) {
        return minVersion == null || minVersion.major == 5 && minVersion.minor == 0 && minVersion.patch < 3;
    }

    public static String toSerializedFormat(Map<String, Index.Status> indexStatusMap) {
        HashMap<String, Map> serialized = new HashMap<String, Map>();
        for (Map.Entry<String, Index.Status> e : indexStatusMap.entrySet()) {
            String[] keyspaceAndIndex = e.getKey().split("\\.");
            serialized.computeIfAbsent(keyspaceAndIndex[0], ignore -> new HashMap()).put(keyspaceAndIndex[1], e.getValue().code);
        }
        return JsonUtils.writeAsJsonString(serialized);
    }

    @VisibleForTesting
    public synchronized Index.Status getIndexStatus(InetAddressAndPort peer, String keyspace, String index) {
        return this.peerIndexStatus.getOrDefault(peer, Collections.emptyMap()).getOrDefault(this.identifier(keyspace, index), Index.Status.UNKNOWN);
    }

    @Nonnull
    private Set<String> removedIndexStatuses(@Nullable Map<String, Index.Status> oldStatus, @Nonnull Map<String, Index.Status> newStatus) {
        if (oldStatus == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(oldStatus.keySet());
        result.removeAll(newStatus.keySet());
        return result;
    }

    @Nonnull
    private Map<String, Index.Status> updatedIndexStatuses(@Nullable Map<String, Index.Status> oldStatus, @Nonnull Map<String, Index.Status> newStatus) {
        HashMap<String, Index.Status> delta = new HashMap<String, Index.Status>();
        for (Map.Entry<String, Index.Status> e : newStatus.entrySet()) {
            if (oldStatus != null && e.getValue() == oldStatus.get(e.getKey())) continue;
            delta.put(e.getKey(), e.getValue());
        }
        return delta;
    }

    private String identifier(String keyspace, String index) {
        return keyspace + "." + index;
    }
}

