/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.Arrays;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplittingSizeTieredCompactionWriter
extends CompactionAwareWriter {
    private static final Logger logger = LoggerFactory.getLogger(SplittingSizeTieredCompactionWriter.class);
    public static final long DEFAULT_SMALLEST_SSTABLE_BYTES = 50000000L;
    private final double[] ratios;
    private final long totalSize;
    private final Set<SSTableReader> allSSTables;
    private long currentBytesToWrite;
    private int currentRatioIndex = 0;

    public SplittingSizeTieredCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
        this(cfs, directories, txn, nonExpiredSSTables, 50000000L);
    }

    public SplittingSizeTieredCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long smallestSSTable) {
        super(cfs, directories, txn, nonExpiredSSTables, false);
        this.allSSTables = txn.originals();
        this.totalSize = cfs.getExpectedCompactedFileSize(nonExpiredSSTables, txn.opType());
        double[] potentialRatios = new double[20];
        double currentRatio = 1.0;
        for (int i = 0; i < potentialRatios.length; ++i) {
            potentialRatios[i] = currentRatio /= 2.0;
        }
        int noPointIndex = 0;
        for (double ratio : potentialRatios) {
            ++noPointIndex;
            if (ratio * (double)this.totalSize < (double)smallestSSTable) break;
        }
        this.ratios = Arrays.copyOfRange(potentialRatios, 0, noPointIndex);
        this.currentBytesToWrite = Math.round((double)this.totalSize * this.ratios[this.currentRatioIndex]);
    }

    @Override
    protected boolean shouldSwitchWriterInCurrentLocation(DecoratedKey key) {
        if (this.sstableWriter.currentWriter().getEstimatedOnDiskBytesWritten() > this.currentBytesToWrite && this.currentRatioIndex < this.ratios.length - 1) {
            ++this.currentRatioIndex;
            this.currentBytesToWrite = this.getExpectedWriteSize();
            logger.debug("Switching writer, currentBytesToWrite = {}", (Object)this.currentBytesToWrite);
            return true;
        }
        return false;
    }

    @Override
    protected int sstableLevel() {
        return 0;
    }

    @Override
    protected long sstableKeyCount() {
        long currentPartitionsToWrite = Math.round(this.ratios[this.currentRatioIndex] * (double)this.estimatedTotalKeys);
        logger.trace("Switching writer, currentPartitionsToWrite = {}", (Object)currentPartitionsToWrite);
        return currentPartitionsToWrite;
    }

    @Override
    protected long getExpectedWriteSize() {
        return Math.round((double)this.totalSize * this.ratios[this.currentRatioIndex]);
    }
}

