/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.CassandraWriteContext;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.TableWriteHandler;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.tracing.Tracing;

public class CassandraTableWriteHandler
implements TableWriteHandler {
    private final ColumnFamilyStore cfs;

    public CassandraTableWriteHandler(ColumnFamilyStore cfs) {
        this.cfs = cfs;
    }

    @Override
    public void write(PartitionUpdate update, WriteContext context, boolean updateIndexes) {
        CassandraWriteContext ctx = CassandraWriteContext.fromContext(context);
        Tracing.trace("Adding to {} memtable", (Object)update.metadata().name);
        this.cfs.apply(update, ctx, updateIndexes);
    }
}

