/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.utils.JVMStabilityInspector;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger anonymousCounter = new AtomicInteger();
    private static volatile String globalPrefix;
    public final String id;
    private final int priority;
    private final ClassLoader contextClassLoader;
    public final ThreadGroup threadGroup;
    protected final AtomicInteger n = new AtomicInteger(1);
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public static void setGlobalPrefix(String prefix) {
        globalPrefix = prefix;
    }

    public static String globalPrefix() {
        String prefix = globalPrefix;
        return prefix == null ? "" : prefix;
    }

    public NamedThreadFactory(String id) {
        this(id, 5);
    }

    public NamedThreadFactory(String id, int priority) {
        this(id, priority, null, null, JVMStabilityInspector::uncaughtException);
    }

    public NamedThreadFactory(String id, ClassLoader contextClassLoader, ThreadGroup threadGroup) {
        this(id, 5, contextClassLoader, threadGroup, JVMStabilityInspector::uncaughtException);
    }

    public NamedThreadFactory(String id, int priority, ClassLoader contextClassLoader, ThreadGroup threadGroup) {
        this(id, priority, contextClassLoader, threadGroup, JVMStabilityInspector::uncaughtException);
    }

    public NamedThreadFactory(String id, int priority, ClassLoader contextClassLoader, ThreadGroup threadGroup, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.id = id;
        this.priority = priority;
        this.contextClassLoader = contextClassLoader;
        this.threadGroup = threadGroup;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this.id + ":" + this.n.getAndIncrement();
        return this.newThread(this.threadGroup, runnable, name);
    }

    protected Thread newThread(ThreadGroup threadGroup, Runnable runnable, String name) {
        return this.setupThread(NamedThreadFactory.createThread(threadGroup, runnable, name, true));
    }

    protected <T extends Thread> T setupThread(T thread) {
        return NamedThreadFactory.setupThread(thread, this.priority, this.contextClassLoader, this.uncaughtExceptionHandler);
    }

    public static Thread createThread(ThreadGroup threadGroup, Runnable runnable, String name, int priority, ClassLoader contextClassLoader, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        String prefix = globalPrefix;
        Thread thread = NamedThreadFactory.createThread(threadGroup, runnable, (String)(prefix != null ? prefix + name : name), true);
        thread.setPriority(priority);
        if (contextClassLoader != null) {
            thread.setContextClassLoader(contextClassLoader);
        }
        if (uncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        return thread;
    }

    @VisibleForTesting
    public static Thread createAnonymousThread(Runnable runnable) {
        return NamedThreadFactory.createThread(null, runnable, "anonymous-" + anonymousCounter.incrementAndGet());
    }

    public static Thread createThread(Runnable runnable, String name) {
        return NamedThreadFactory.createThread(null, runnable, name);
    }

    public Thread createThread(Runnable runnable, String name, boolean daemon) {
        return NamedThreadFactory.createThread(null, runnable, name, daemon);
    }

    public static Thread createThread(ThreadGroup threadGroup, Runnable runnable, String name) {
        return NamedThreadFactory.createThread(threadGroup, runnable, name, false);
    }

    public static Thread createThread(ThreadGroup threadGroup, Runnable runnable, String name, boolean daemon) {
        String prefix = globalPrefix;
        FastThreadLocalThread thread = new FastThreadLocalThread(threadGroup, runnable, (String)(prefix != null ? prefix + name : name));
        thread.setDaemon(daemon);
        return thread;
    }

    public static <T extends Thread> T setupThread(T thread, int priority, ClassLoader contextClassLoader, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        thread.setPriority(priority);
        if (contextClassLoader != null) {
            thread.setContextClassLoader(contextClassLoader);
        }
        if (uncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        return thread;
    }

    public String toString() {
        return this.threadGroup != null ? this.id + " in " + this.threadGroup.getName() : this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ThreadGroup threadGroup = this.threadGroup;
        synchronized (threadGroup) {
            this.threadGroup.setDaemon(true);
            try {
                this.threadGroup.destroy();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    public static class MetaFactory {
        protected ClassLoader contextClassLoader;
        protected ThreadGroup threadGroup;
        protected Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        public MetaFactory(ClassLoader contextClassLoader, ThreadGroup threadGroup, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.contextClassLoader = contextClassLoader;
            if (threadGroup == null) {
                threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup.getParent() != null) {
                    threadGroup = threadGroup.getParent();
                }
            }
            this.threadGroup = threadGroup;
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        }

        NamedThreadFactory newThreadFactory(String name, int threadPriority) {
            ThreadGroup threadGroup = this.threadGroup == null ? null : new ThreadGroup(this.threadGroup, name);
            return new NamedThreadFactory(name, threadPriority, this.contextClassLoader, threadGroup, this.uncaughtExceptionHandler);
        }
    }
}

