/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.net.URL;
import java.util.function.Supplier;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.internal.FileMarshallableOut;
import net.openhft.chronicle.wire.internal.HTTPMarshallableOut;

public class MarshallableOutBuilder
implements Supplier<MarshallableOut> {
    private final URL url;
    private WireType wireType;

    public MarshallableOutBuilder(URL url) {
        this.url = url;
    }

    @Override
    public MarshallableOut get() {
        switch (this.url.getProtocol()) {
            case "tcp": {
                throw new UnsupportedOperationException("Direct TCP connection not implemented");
            }
            case "file": {
                if (this.wireType != null && this.wireType != WireType.YAML_ONLY) {
                    throw new IllegalArgumentException("Unsupported wireType; " + this.wireType);
                }
                return new FileMarshallableOut(this, this.wireTypeOr(WireType.YAML_ONLY));
            }
            case "http": 
            case "https": {
                if (this.wireType != null && this.wireType != WireType.JSON_ONLY) {
                    throw new IllegalArgumentException("Unsupported wireType; " + this.wireType);
                }
                return new HTTPMarshallableOut(this, this.wireTypeOr(WireType.JSON_ONLY));
            }
        }
        throw new UnsupportedOperationException("Writing to " + this.url.getProtocol() + " is  not implemented");
    }

    private WireType wireTypeOr(WireType wireType) {
        return this.wireType == null ? wireType : this.wireType;
    }

    public URL url() {
        return this.url;
    }

    public MarshallableOutBuilder wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }
}

