/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.codec.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.gridkit.jvmtool.util.json.JsonStreamWriter;

public class JsonStreamHandler
implements JsonStreamWriter {
    public static boolean TRACE = false;
    public static final JsonNullHandler NULL_HANDLER = new JsonNullHandler();
    private List<JsonEntityHandler> handlerStack = new ArrayList<JsonEntityHandler>();
    private boolean starting;
    private String fieldName;

    public void reset(JsonEntityHandler handler) {
        this.handlerStack.clear();
        this.push(handler);
        this.starting = true;
    }

    public boolean isAcomplished() {
        return this.handlerStack.isEmpty();
    }

    protected JsonEntityHandler top() {
        if (this.handlerStack.isEmpty()) {
            throw new IllegalStateException("Parsing complete");
        }
        return this.handlerStack.get(this.handlerStack.size() - 1);
    }

    protected void push(JsonEntityHandler handler) {
        this.handlerStack.add(handler);
    }

    protected void pop() {
        this.handlerStack.remove(this.handlerStack.size() - 1);
    }

    protected JsonListHandler topListHandler() {
        if (this.handlerStack.isEmpty()) {
            throw new IllegalStateException("Parsing complete");
        }
        JsonEntityHandler h = this.handlerStack.get(this.handlerStack.size() - 1);
        if (h instanceof JsonListHandler) {
            return (JsonListHandler)h;
        }
        throw new IllegalStateException("Unexpected object content");
    }

    protected JsonObjectHandler topObjectHandler() {
        if (this.handlerStack.isEmpty()) {
            throw new IllegalStateException("Parsing complete");
        }
        JsonEntityHandler h = this.handlerStack.get(this.handlerStack.size() - 1);
        if (h instanceof JsonObjectHandler) {
            return (JsonObjectHandler)h;
        }
        throw new IllegalStateException("Unexpected list content");
    }

    public void writeStartArray() throws IOException {
        if (TRACE) {
            System.out.println("writeStartArray");
        }
        if (this.starting) {
            this.starting = false;
            this.topListHandler();
        } else if (this.fieldName == null) {
            this.push(this.topListHandler().onNextEntity());
        } else {
            this.push(this.topObjectHandler().onEntityField(this.fieldName));
        }
        this.fieldName = null;
    }

    public void writeEndArray() throws IOException {
        if (TRACE) {
            System.out.println("writeEndArray");
        }
        this.topListHandler().onListComplete();
        this.pop();
    }

    public void writeStartObject() throws IOException {
        if (TRACE) {
            System.out.println("writeStartObject");
        }
        if (this.starting) {
            this.starting = false;
            this.topObjectHandler();
        } else if (this.fieldName == null) {
            this.push(this.topListHandler().onNextEntity());
        } else {
            this.push(this.topObjectHandler().onEntityField(this.fieldName));
        }
        this.fieldName = null;
    }

    public void writeEndObject() throws IOException {
        if (TRACE) {
            System.out.println("writeEndObject");
        }
        this.topObjectHandler().onObjectComplete();
        this.pop();
    }

    public void writeFieldName(String name) throws IOException {
        if (TRACE) {
            System.out.println("writeFieldName: " + name);
        }
        this.topObjectHandler();
        this.fieldName = name;
    }

    protected void onValue(Object val) {
        if (TRACE) {
            System.out.println("writeValue: " + val);
        }
        if (this.fieldName == null) {
            this.topListHandler().onNextValue(val);
        } else {
            this.topObjectHandler().onScalarFieldValue(this.fieldName, val);
        }
        this.fieldName = null;
    }

    public void writeString(String text) throws IOException {
        this.onValue(text);
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.onValue(new String(text, offset, len));
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(String text) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(char c) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRawValue(String text) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeNumber(int v) throws IOException {
        this.onValue(v);
    }

    public void writeNumber(long v) throws IOException {
        this.onValue(v);
    }

    public void writeNumber(BigInteger v) throws IOException {
        this.onValue(v);
    }

    public void writeNumber(double d) throws IOException {
        this.onValue(d);
    }

    public void writeNumber(float f) throws IOException {
        this.onValue(Float.valueOf(f));
    }

    public void writeNumber(BigDecimal dec) throws IOException {
        this.onValue(dec);
    }

    public void writeNumber(String encodedValue) throws IOException, UnsupportedOperationException {
        this.onValue(encodedValue);
    }

    public void writeBoolean(boolean state) throws IOException {
        this.onValue(state);
    }

    public void writeNull() throws IOException {
        this.onValue(null);
    }

    public void writeStringField(String fieldName, String value) throws IOException {
        this.writeFieldName(fieldName);
        this.writeString(value);
    }

    public void writeBooleanField(String fieldName, boolean value) throws IOException {
        this.writeFieldName(fieldName);
        this.writeBoolean(value);
    }

    public void writeNullField(String fieldName) throws IOException {
        this.writeFieldName(fieldName);
        this.writeNull();
    }

    public void writeNumberField(String fieldName, int value) throws IOException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public void writeNumberField(String fieldName, long value) throws IOException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public void writeNumberField(String fieldName, double value) throws IOException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public void writeNumberField(String fieldName, float value) throws IOException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public void writeNumberField(String fieldName, BigDecimal value) throws IOException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public void writeArrayFieldStart(String fieldName) throws IOException {
        this.writeFieldName(fieldName);
        this.writeStartArray();
    }

    public void writeObjectFieldStart(String fieldName) throws IOException {
        this.writeFieldName(fieldName);
        this.writeStartObject();
    }

    public static class JsonNullHandler
    implements JsonListHandler,
    JsonObjectHandler {
        @Override
        public void onScalarFieldValue(String fieldName, Object val) {
        }

        @Override
        public JsonEntityHandler onEntityField(String fieldName) {
            return this;
        }

        @Override
        public void onObjectComplete() {
        }

        @Override
        public JsonEntityHandler onNextEntity() {
            return this;
        }

        @Override
        public void onNextValue(Object val) {
        }

        @Override
        public void onListComplete() {
        }
    }

    public static interface JsonObjectHandler
    extends JsonEntityHandler {
        public void onScalarFieldValue(String var1, Object var2);

        public JsonEntityHandler onEntityField(String var1);

        public void onObjectComplete();
    }

    public static interface JsonListHandler
    extends JsonEntityHandler {
        public JsonEntityHandler onNextEntity();

        public void onNextValue(Object var1);

        public void onListComplete();
    }

    public static interface JsonEntityHandler {
    }
}

