/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import sun.misc.Unsafe;

public final class VM {
    private static final boolean DEFAULT_USE_COMPRESSED_OOPS = true;
    private static final int DEFAULT_ALIGNMENT_IN_BYTES = 8;
    private static final int DEFAULT_CONTENDED_PADDING_WIDTH = 128;
    private static final boolean IS_PRE_JAVA12_JVM = !VM.supportStringIndentMethod();
    private static final Unsafe UNSAFE = VM.loadUnsafe();

    private static boolean supportStringIndentMethod() {
        try {
            String.class.getMethod("indent", Integer.TYPE);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getVMOption(String option) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName mbean = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
            CompositeDataSupport data = (CompositeDataSupport)server.invoke(mbean, "getVMOption", new Object[]{option}, new String[]{"java.lang.String"});
            return data.get("value").toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getObjectAlignmentInBytes() {
        String alignment = VM.getVMOption("ObjectAlignmentInBytes");
        return alignment == null ? 8 : Integer.parseInt(alignment);
    }

    public static boolean useCompressedOops() {
        String useCompressedOops = VM.getVMOption("UseCompressedOops");
        return useCompressedOops == null ? true : Boolean.parseBoolean(useCompressedOops);
    }

    public static boolean useCompressedClassPointers() {
        String useCompressedClassPointers = VM.getVMOption("UseCompressedClassPointers");
        return useCompressedClassPointers == null ? VM.useCompressedOops() : Boolean.parseBoolean(useCompressedClassPointers);
    }

    public static boolean useEmptySlotsInSuper() {
        String useEmptySlotsInSuper = VM.getVMOption("UseEmptySlotsInSupers");
        return useEmptySlotsInSuper == null ? false : Boolean.parseBoolean(useEmptySlotsInSuper);
    }

    public static boolean restrictContended() {
        String restrictContended = VM.getVMOption("RestrictContended");
        return restrictContended == null ? true : Boolean.parseBoolean(restrictContended);
    }

    public static boolean enableContended() {
        String enableContended = VM.getVMOption("EnableContended");
        return enableContended == null ? true : Boolean.parseBoolean(enableContended);
    }

    public static int contendedPaddingWidth() {
        String contendedPaddingWidth = VM.getVMOption("ContendedPaddingWidth");
        return contendedPaddingWidth == null ? 128 : Integer.parseInt(contendedPaddingWidth);
    }

    public static boolean is32Bits() {
        return "32".equals(System.getProperty("sun.arch.data.model"));
    }

    public static boolean isPreJava12JVM() {
        return IS_PRE_JAVA12_JVM;
    }

    public static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    public static void printOffsets(Object obj) {
        if (UNSAFE == null) {
            throw new IllegalStateException("printOffsets relies on Unsafe which could not be loaded");
        }
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            System.out.println("---------------------------------------------------------------------------------");
            System.out.println("Memory layout for: " + obj.getClass().getComponentType().getName() + "[]");
            System.out.println("arrayBaseOffset : " + UNSAFE.arrayBaseOffset(obj.getClass()));
            System.out.println("---------------------------------------------------------------------------------");
        } else {
            TreeMap<Long, String> fieldInfo = new TreeMap<Long, String>();
            while (type != null) {
                for (Field f : type.getDeclaredFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    long offset = UNSAFE.objectFieldOffset(f);
                    Class<?> fieldType = f.getType();
                    String fieldTypeAsString = fieldType.isArray() ? fieldType.getComponentType().getName() + "[]" : fieldType.getName();
                    fieldInfo.put(offset, "class=" + type.getName() + ", field=" + f.getName() + ", offset=" + offset + ", field type=" + fieldTypeAsString);
                }
                type = type.getSuperclass();
            }
            System.out.println("---------------------------------------------------------------------------------");
            System.out.println("Memory layout for: " + obj.getClass().getName());
            fieldInfo.forEach((k, v) -> System.out.println((String)v));
            System.out.println("---------------------------------------------------------------------------------");
        }
    }

    private static Unsafe loadUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (Exception ex) {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private VM() {
    }
}

