/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package [=javaPackageBase].it;

import java.net.URI;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

[#if nativeSupported ]
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
[#else]
import org.apache.camel.CamelContext;
[/#if]
import org.jboss.logging.Logger;

@Path("/[=artifactIdBase]")
@ApplicationScoped
public class [=toCapCamelCase(artifactIdBase)]Resource {

    private static final Logger LOG = Logger.getLogger([=toCapCamelCase(artifactIdBase)]Resource.class);

[#if nativeSupported ]
    @Inject
    ProducerTemplate producerTemplate;

    @Inject
    ConsumerTemplate consumerTemplate;

    @Path("/get")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public String get() throws Exception {
        final String message = consumerTemplate.receiveBodyNoWait("[=artifactIdBase]:--fix-me--", String.class);
        LOG.infof("Received from [=artifactIdBase]: %s", message);
        return message;
    }

    @Path("/post")
    @POST
    @Consumes(MediaType.TEXT_PLAIN)
    @Produces(MediaType.TEXT_PLAIN)
    public Response post(String message) throws Exception {
        LOG.infof("Sending to [=artifactIdBase]: %s", message);
        final String response = producerTemplate.requestBody("[=artifactIdBase]:--fix-me--", message, String.class);
        LOG.infof("Got response from [=artifactIdBase]: %s", response);
        return Response
                .created(new URI("https://camel.apache.org/"))
                .entity(response)
                .build();
    }
[#else]
[#list models as m]
    private static final String [=toSnakeCase(m.kind)?upper_case]_[=toSnakeCase(m.name)?upper_case] = "[=m.name]";
[/#list]
    @Inject
    CamelContext context;

[#list models as model]
    @Path("/load/[=model.kind]/[=toKebabCase(model.name)]")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response load[=toCapCamelCase(model.kind)][=toCapCamelCase(model.name)]() throws Exception {
        /* This is an autogenerated test */
[#if model.kind == "other" ]
        /* No way to test a Camel artifact of kind "other" */
        return Response.ok().build();
[#else]
[#if model.kind == "component" ]
[#assign contextMethod = "getComponent"]
[#elseif model.kind == "language" ]
[#assign contextMethod = "resolveLanguage"]
[#elseif model.kind == "dataformat" ]
[#assign contextMethod = "resolveDataFormat"]
[#else]
[#stop "Unexpected Camel artifact kind " + model.kind ]
[/#if]
[#assign schemeVarName = "[=toSnakeCase(model.kind)?upper_case]_[=toSnakeCase(model.name)?upper_case]"]
        if (context.[=contextMethod]([=schemeVarName]) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", [=schemeVarName]);
        return Response.status(500, [=schemeVarName] + " could not be loaded from the Camel context").build();
[/#if]
    }
[/#list]
[/#if]
}
