/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.util.ByteBufList;

class ResponseBuilder {
    ResponseBuilder() {
    }

    static BookieProtocol.Response buildErrorResponse(int errorCode, BookieProtocol.Request r) {
        if (r.getOpCode() == 1) {
            return BookieProtocol.AddResponse.create(r.getProtocolVersion(), errorCode, r.getLedgerId(), r.getEntryId());
        }
        if (r.getOpCode() == 2) {
            return new BookieProtocol.ReadResponse(r.getProtocolVersion(), errorCode, r.getLedgerId(), r.getEntryId());
        }
        assert (r.getOpCode() == 7);
        return new BookieProtocol.BatchedReadResponse(r.getProtocolVersion(), errorCode, r.getLedgerId(), r.getEntryId(), ((BookieProtocol.BatchedReadRequest)r).getRequestId());
    }

    static BookieProtocol.Response buildAddResponse(BookieProtocol.Request r) {
        return BookieProtocol.AddResponse.create(r.getProtocolVersion(), 0, r.getLedgerId(), r.getEntryId());
    }

    static BookieProtocol.Response buildReadResponse(ByteBuf data, BookieProtocol.Request r) {
        return new BookieProtocol.ReadResponse(r.getProtocolVersion(), 0, r.getLedgerId(), r.getEntryId(), data);
    }

    static BookieProtocol.Response buildBatchedReadResponse(ByteBufList data, BookieProtocol.BatchedReadRequest r) {
        return new BookieProtocol.BatchedReadResponse(r.getProtocolVersion(), 0, r.getLedgerId(), r.getEntryId(), r.getRequestId(), data);
    }
}

