/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(SessionTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private ServerCnxnFactory serverFactory;
    private ZooKeeperServer zs;
    private CountDownLatch startSignal;
    File tmpDir;
    private final int TICK_TIME = 3000;

    @BeforeEach
    public void setUp() throws Exception {
        if (this.tmpDir == null) {
            this.tmpDir = ClientBase.createTmpDir();
        }
        ClientBase.setupTestEnv();
        this.zs = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        this.serverFactory = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        this.serverFactory.startup(this.zs);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server up");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.serverFactory.shutdown();
        this.zs.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
    }

    private DisconnectableZooKeeper createClient() throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(ClientBase.CONNECTION_TIMEOUT, watcher);
    }

    private DisconnectableZooKeeper createClient(int timeout) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(timeout, watcher);
    }

    private DisconnectableZooKeeper createClient(int timeout, CountdownWatcher watcher) throws IOException, InterruptedException {
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(HOSTPORT, timeout, watcher);
        if (!watcher.clientConnected.await(timeout, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Unable to connect to server");
        }
        return zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSession() throws IOException, InterruptedException, KeeperException {
        DisconnectableZooKeeper zk = this.createClient();
        zk.create("/e", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        LOG.info("zk with session id 0x{} was destroyed!", (Object)Long.toHexString(zk.getSessionId()));
        zk.disconnect();
        Stat stat = new Stat();
        this.startSignal = new CountDownLatch(1);
        zk = new DisconnectableZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, new MyWatcher("testSession"), zk.getSessionId(), zk.getSessionPasswd());
        this.startSignal.await();
        LOG.info("zk with session id 0x{} was created!", (Object)Long.toHexString(zk.getSessionId()));
        zk.getData("/e", false, stat);
        LOG.info("After get data /e");
        zk.close();
        zk = this.createClient();
        Assertions.assertEquals(null, (Object)zk.exists("/e", false));
        LOG.info("before close zk with session id 0x{}!", (Object)Long.toHexString(zk.getSessionId()));
        zk.close();
        try {
            zk.getData("/e", false, stat);
            Assertions.fail((String)"Should have received a SessionExpiredException");
        }
        catch (KeeperException.SessionExpiredException sessionExpiredException) {
            // empty catch block
        }
        AsyncCallback.DataCallback cb = new AsyncCallback.DataCallback(){
            String status = "not done";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResult(int rc, String p, Object c, byte[] b, Stat s) {
                1 var6_6 = this;
                synchronized (var6_6) {
                    this.status = KeeperException.Code.get((int)rc).toString();
                    this.notify();
                }
            }

            public String toString() {
                return this.status;
            }
        };
        zk.getData("/e", false, cb, null);
        AsyncCallback.DataCallback dataCallback = cb;
        synchronized (dataCallback) {
            if (cb.toString().equals("not done")) {
                cb.wait(1000L);
            }
        }
        Assertions.assertEquals((Object)KeeperException.Code.SESSIONEXPIRED.toString(), (Object)cb.toString());
    }

    @Test
    public void testSessionMove() throws Exception {
        String[] hostPorts = HOSTPORT.split(",");
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hostPorts[0], ClientBase.CONNECTION_TIMEOUT, new MyWatcher("0"));
        zk.create("/sessionMoveTest", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        for (int i = 0; i < hostPorts.length * 2; ++i) {
            zk.dontReconnect();
            DisconnectableZooKeeper zknew = new DisconnectableZooKeeper(hostPorts[(i + 1) % hostPorts.length], ClientBase.CONNECTION_TIMEOUT, new MyWatcher(Integer.toString(i + 1)), zk.getSessionId(), zk.getSessionPasswd());
            zknew.sync("/");
            LOG.info("{} Sync succeed", (Object)hostPorts[(i + 1) % hostPorts.length]);
            zknew.setData("/", new byte[1], -1);
            try {
                zk.setData("/", new byte[1], -1);
                Assertions.fail((String)"Should have lost the connection");
            }
            catch (KeeperException.ConnectionLossException e) {
                LOG.info("Got connection loss exception as expected");
            }
            zk = zknew;
        }
        zk.close();
    }

    @Test
    public void testSessionStateNoDupStateReporting() throws IOException, InterruptedException, KeeperException {
        int TIMEOUT = 3000;
        DupWatcher watcher = new DupWatcher();
        DisconnectableZooKeeper zk = this.createClient(3000, watcher);
        this.serverFactory.shutdown();
        watcher.sessionTerminated.await();
        List<Watcher.Event.KeeperState> states = Arrays.asList(Watcher.Event.KeeperState.SyncConnected, Watcher.Event.KeeperState.Disconnected, Watcher.Event.KeeperState.Expired);
        Assertions.assertEquals(states, watcher.states);
        zk.close();
    }

    @Test
    public void testSessionTimeoutAccess() throws Exception {
        DisconnectableZooKeeper zk = this.createClient(12000);
        Assertions.assertEquals((int)12000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(3000);
        Assertions.assertEquals((int)6000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(90000);
        Assertions.assertEquals((int)60000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
    }

    @Test
    public void testMinMaxSessionTimeout() throws Exception {
        int MINSESS = 20000;
        int MAXSESS = 240000;
        ZooKeeperServer zs = this.serverFactory.getZooKeeperServer();
        zs.setMinSessionTimeout(20000);
        zs.setMaxSessionTimeout(240000);
        int timeout = 120000;
        DisconnectableZooKeeper zk = this.createClient(timeout);
        Assertions.assertEquals((int)timeout, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(10000);
        Assertions.assertEquals((int)20000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(480000);
        Assertions.assertEquals((int)240000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
    }

    @Test
    public void testMaximumCnxnPerIP() throws Exception {
        int maxClientCnxnsPerIP = 3;
        this.serverFactory.setMaxClientCnxnsPerHost(3);
        ZooKeeper[] clients = new ZooKeeper[4];
        for (int i = 0; i < clients.length; ++i) {
            CountdownWatcher watcher = new CountdownWatcher();
            int timeout = 3000;
            clients[i] = new DisconnectableZooKeeper(HOSTPORT, timeout, watcher);
            boolean result = watcher.clientConnected.await(timeout, TimeUnit.MILLISECONDS);
            if (i >= 3) {
                Assertions.assertFalse((boolean)result);
                continue;
            }
            Assertions.assertTrue((boolean)result);
        }
    }

    private class DupWatcher
    extends CountdownWatcher {
        public List<Watcher.Event.KeeperState> states;

        private DupWatcher() {
            this.states = new LinkedList<Watcher.Event.KeeperState>();
        }

        @Override
        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() == Watcher.Event.EventType.None) {
                this.states.add(event.getState());
            }
        }
    }

    private class MyWatcher
    implements Watcher {
        private String name;

        public MyWatcher(String name) {
            this.name = name;
        }

        public void process(WatchedEvent event) {
            LOG.info("{} event:{} {} {}", new Object[]{this.name, event.getState(), event.getType(), event.getPath()});
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected && SessionTest.this.startSignal != null && SessionTest.this.startSignal.getCount() > 0L) {
                SessionTest.this.startSignal.countDown();
            }
        }
    }

    private static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected = new CountDownLatch(1);
        final CountDownLatch sessionTerminated = new CountDownLatch(1);

        private CountdownWatcher() {
        }

        public void process(WatchedEvent event) {
            switch (event.getState()) {
                case SyncConnected: {
                    this.clientConnected.countDown();
                    break;
                }
                case AuthFailed: 
                case Expired: 
                case Closed: {
                    this.sessionTerminated.countDown();
                }
            }
        }
    }
}

