/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.watch.IDeadWatcherListener;
import org.apache.zookeeper.server.watch.WatcherCleaner;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherCleanerTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(WatcherCleanerTest.class);

    @Test
    public void testProcessDeadWatchersBasedOnThreshold() {
        MyDeadWatcherListener listener = new MyDeadWatcherListener();
        int threshold = 3;
        WatcherCleaner cleaner = new WatcherCleaner((IDeadWatcherListener)listener, threshold, 60, 1, 10);
        cleaner.start();
        int i = 0;
        while (i++ < threshold - 1) {
            cleaner.addDeadWatcher(i);
        }
        Assertions.assertEquals((int)0, (int)listener.getDeadWatchers().size());
        listener.setCountDownLatch(new CountDownLatch(1));
        cleaner.addDeadWatcher(i);
        Assertions.assertTrue((boolean)listener.wait(1000));
        Assertions.assertEquals((int)threshold, (int)listener.getDeadWatchers().size());
    }

    @Test
    public void testProcessDeadWatchersBasedOnTime() {
        MyDeadWatcherListener listener = new MyDeadWatcherListener();
        WatcherCleaner cleaner = new WatcherCleaner((IDeadWatcherListener)listener, 10, 1, 1, 10);
        cleaner.start();
        cleaner.addDeadWatcher(1);
        Assertions.assertEquals((int)0, (int)listener.getDeadWatchers().size());
        listener.setCountDownLatch(new CountDownLatch(1));
        Assertions.assertTrue((boolean)listener.wait(2000));
        Assertions.assertEquals((int)1, (int)listener.getDeadWatchers().size());
        listener.setCountDownLatch(new CountDownLatch(1));
        Assertions.assertFalse((boolean)listener.wait(2000));
    }

    @Test
    public void testMaxInProcessingDeadWatchers() {
        MyDeadWatcherListener listener = new MyDeadWatcherListener();
        int delayMs = 1000;
        listener.setDelayMs(delayMs);
        WatcherCleaner cleaner = new WatcherCleaner((IDeadWatcherListener)listener, 1, 60, 1, 1);
        cleaner.start();
        listener.setCountDownLatch(new CountDownLatch(2));
        long startTime = Time.currentElapsedTime();
        cleaner.addDeadWatcher(1);
        cleaner.addDeadWatcher(2);
        long time = Time.currentElapsedTime() - startTime;
        System.out.println("time used " + time);
        Assertions.assertTrue((Time.currentElapsedTime() - startTime >= (long)delayMs ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)listener.wait(5000));
    }

    @Test
    public void testDeadWatcherMetrics() throws InterruptedException {
        ServerMetrics.getMetrics().resetAll();
        MyDeadWatcherListener listener = new MyDeadWatcherListener();
        WatcherCleaner cleaner = new WatcherCleaner((IDeadWatcherListener)listener, 1, 1, 1, 1);
        listener.setDelayMs(20);
        cleaner.start();
        listener.setCountDownLatch(new CountDownLatch(3));
        cleaner.addDeadWatcher(1);
        cleaner.addDeadWatcher(2);
        cleaner.addDeadWatcher(3);
        Assertions.assertTrue((boolean)listener.wait(5000));
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        WatcherCleanerTest.waitForMetric("add_dead_watcher_stall_time", Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        WatcherCleanerTest.waitForMetric("dead_watchers_queued", Matchers.is((Object)3L));
        WatcherCleanerTest.waitForMetric("dead_watchers_cleared", Matchers.is((Object)3L));
        WatcherCleanerTest.waitForMetric("cnt_dead_watchers_cleaner_latency", Matchers.is((Object)3L));
        WatcherCleanerTest.waitForMetric("avg_dead_watchers_cleaner_latency", WatcherCleanerTest.closeTo(20.0, 5.0));
        WatcherCleanerTest.waitForMetric("min_dead_watchers_cleaner_latency", WatcherCleanerTest.closeTo(20.0, 5.0));
        WatcherCleanerTest.waitForMetric("max_dead_watchers_cleaner_latency", WatcherCleanerTest.closeTo(20.0, 5.0));
        WatcherCleanerTest.waitForMetric("p50_dead_watchers_cleaner_latency", WatcherCleanerTest.closeTo(20.0, 5.0));
        WatcherCleanerTest.waitForMetric("p95_dead_watchers_cleaner_latency", WatcherCleanerTest.closeTo(20.0, 5.0));
        WatcherCleanerTest.waitForMetric("p99_dead_watchers_cleaner_latency", WatcherCleanerTest.closeTo(20.0, 5.0));
    }

    public static class MyDeadWatcherListener
    implements IDeadWatcherListener {
        private CountDownLatch latch;
        private int delayMs;
        private Set<Integer> deadWatchers = new HashSet<Integer>();

        public void setCountDownLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public void setDelayMs(int delayMs) {
            this.delayMs = delayMs;
        }

        public void processDeadWatchers(Set<Integer> deadWatchers) {
            if (this.delayMs > 0) {
                try {
                    Thread.sleep(this.delayMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.deadWatchers.clear();
            this.deadWatchers.addAll(deadWatchers);
            this.latch.countDown();
        }

        public Set<Integer> getDeadWatchers() {
            return this.deadWatchers;
        }

        public boolean wait(int maxWaitMs) {
            try {
                return this.latch.await(maxWaitMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }
}

