/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.metric;

import java.util.Map;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.metric.AvgMinMaxCounterSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AvgMinMaxCounterSetTest
extends ZKTestCase {
    private AvgMinMaxCounterSet testCounterSet;

    @BeforeEach
    public void initCounter() {
        this.testCounterSet = new AvgMinMaxCounterSet("test");
    }

    private void addDataPoints() {
        this.testCounterSet.add("key1", 0L);
        this.testCounterSet.add("key1", 1L);
        this.testCounterSet.add("key2", 2L);
        this.testCounterSet.add("key2", 3L);
        this.testCounterSet.add("key2", 4L);
        this.testCounterSet.add("key2", 5L);
    }

    @Test
    public void testReset() {
        this.addDataPoints();
        this.testCounterSet.reset();
        Map values = this.testCounterSet.values();
        Assertions.assertEquals((int)10, (int)values.size(), (String)"There should be 10 values in the set");
        Assertions.assertEquals((Object)0.0, values.get("avg_key1_test"), (String)"avg_key1_test should =0");
        Assertions.assertEquals((Object)0L, values.get("min_key1_test"), (String)"min_key1_test should =0");
        Assertions.assertEquals((Object)0L, values.get("max_key1_test"), (String)"max_key1_test should =0");
        Assertions.assertEquals((Object)0L, values.get("cnt_key1_test"), (String)"cnt_key1_test should =0");
        Assertions.assertEquals((Object)0L, values.get("sum_key1_test"), (String)"sum_key1_test should =0");
        Assertions.assertEquals((Object)0.0, values.get("avg_key2_test"), (String)"avg_key2_test should =0");
        Assertions.assertEquals((Object)0L, values.get("min_key2_test"), (String)"min_key2_test should =0");
        Assertions.assertEquals((Object)0L, values.get("max_key2_test"), (String)"max_key2_test should =0");
        Assertions.assertEquals((Object)0L, values.get("cnt_key2_test"), (String)"cnt_key2_test should =0");
        Assertions.assertEquals((Object)0L, values.get("sum_key2_test"), (String)"sum_key2_test should =0");
    }

    @Test
    public void testValues() {
        this.addDataPoints();
        Map values = this.testCounterSet.values();
        Assertions.assertEquals((int)10, (int)values.size(), (String)"There should be 10 values in the set");
        Assertions.assertEquals((Object)0.5, values.get("avg_key1_test"), (String)"avg_key1_test should =0.5");
        Assertions.assertEquals((Object)0L, values.get("min_key1_test"), (String)"min_key1_test should =0");
        Assertions.assertEquals((Object)1L, values.get("max_key1_test"), (String)"max_key1_test should =1");
        Assertions.assertEquals((Object)2L, values.get("cnt_key1_test"), (String)"cnt_key1_test should =2");
        Assertions.assertEquals((Object)1L, values.get("sum_key1_test"), (String)"sum_key1_test should =1");
        Assertions.assertEquals((Object)3.5, values.get("avg_key2_test"), (String)"avg_key2_test should =3.5");
        Assertions.assertEquals((Object)2L, values.get("min_key2_test"), (String)"min_key2_test should =2");
        Assertions.assertEquals((Object)5L, values.get("max_key2_test"), (String)"max_key2_test should =5");
        Assertions.assertEquals((Object)4L, values.get("cnt_key2_test"), (String)"cnt_key2_test should =4");
        Assertions.assertEquals((Object)14L, values.get("sum_key2_test"), (String)"sum_key2_test should =14");
    }
}

