/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import jakarta.xml.ws.handler.MessageContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.SOAPHeadersAdapter;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseMessageContext
implements jakarta.xml.ws.handler.MessageContext {
    private static final Log log = LogFactory.getLog(BaseMessageContext.class);
    protected MessageContext messageCtx;

    protected BaseMessageContext(MessageContext messageCtx) {
        this.messageCtx = messageCtx;
        AttachmentsAdapter.install(messageCtx);
        TransportHeadersAdapter.install(messageCtx);
        SOAPHeadersAdapter.install(messageCtx);
    }

    public void clear() {
        this.messageCtx.getMEPContext().clear();
    }

    public boolean containsKey(Object key) {
        return this.messageCtx.getMEPContext().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.messageCtx.getMEPContext().containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.messageCtx.getMEPContext().entrySet();
    }

    public Object get(Object key) {
        TransportHeadersAdapter adapter;
        Object returnValue = null;
        returnValue = this.shouldPropertySpanMEP(key) ? this.messageCtx.getMEPContext().get(key) : this.messageCtx.getProperty((String)key);
        if (returnValue != null && returnValue instanceof TransportHeadersAdapter && (adapter = (TransportHeadersAdapter)returnValue).isEmpty()) {
            return null;
        }
        return returnValue;
    }

    private boolean shouldPropertySpanMEP(Object key) {
        boolean shouldSpan = true;
        String keyString = (String)key;
        Boolean outbound = (Boolean)this.messageCtx.getMEPContext().get("jakarta.xml.ws.handler.message.outbound");
        if (outbound != null && !outbound.booleanValue() && "jakarta.xml.ws.http.request.headers".equals(keyString)) {
            shouldSpan = false;
        }
        return shouldSpan;
    }

    public boolean isEmpty() {
        return this.messageCtx.getMEPContext().isEmpty();
    }

    public Set<String> keySet() {
        return this.messageCtx.getMEPContext().keySet();
    }

    public Object put(String key, Object value) {
        return this.messageCtx.getMEPContext().put(key, value);
    }

    public void putAll(Map<? extends String, ? extends Object> t) {
        this.messageCtx.getMEPContext().putAll(t);
    }

    public Object remove(Object key) {
        return this.messageCtx.getMEPContext().remove(key);
    }

    public int size() {
        return this.messageCtx.getMEPContext().size();
    }

    public Collection<Object> values() {
        return this.messageCtx.getMEPContext().values();
    }

    public MessageContext.Scope getScope(String s) {
        return this.messageCtx.getMEPContext().getScope(s);
    }

    public void setScope(String s, MessageContext.Scope scope) {
        this.messageCtx.getMEPContext().setScope(s, scope);
    }
}

