/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.mapred.tether.TetherData;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

class TetherKeySerialization
extends Configured
implements Serialization<TetherData> {
    private static final DecoderFactory FACTORY = DecoderFactory.get();

    TetherKeySerialization() {
    }

    @Override
    public boolean accept(Class<?> c) {
        return TetherData.class.isAssignableFrom(c);
    }

    @Override
    public Deserializer<TetherData> getDeserializer(Class<TetherData> c) {
        return new TetherDataDeserializer();
    }

    @Override
    public Serializer<TetherData> getSerializer(Class<TetherData> c) {
        return new TetherDataSerializer();
    }

    private class TetherDataSerializer
    implements Serializer<TetherData> {
        private OutputStream out;
        private BinaryEncoder encoder;

        private TetherDataSerializer() {
        }

        @Override
        public void open(OutputStream out) {
            this.out = out;
            this.encoder = EncoderFactory.get().directBinaryEncoder(out, this.encoder);
        }

        @Override
        public void serialize(TetherData datum) throws IOException {
            this.encoder.writeBytes(datum.buffer());
            this.encoder.flush();
        }

        @Override
        public void close() throws IOException {
            this.encoder.flush();
            this.out.close();
        }
    }

    private class TetherDataDeserializer
    implements Deserializer<TetherData> {
        private BinaryDecoder decoder;

        private TetherDataDeserializer() {
        }

        @Override
        public void open(InputStream in) {
            this.decoder = FACTORY.directBinaryDecoder(in, this.decoder);
        }

        @Override
        public TetherData deserialize(TetherData datum) throws IOException {
            if (datum == null) {
                datum = new TetherData();
            }
            datum.buffer(this.decoder.readBytes(datum.buffer()));
            return datum;
        }

        @Override
        public void close() throws IOException {
            this.decoder.inputStream().close();
        }
    }
}

