# coding: utf-8

"""
    Airflow API

    Airflow API. All endpoints located under ``/api/v2`` can be used safely, are stable and backward compatible. Endpoints located under ``/ui`` are dedicated to the UI and are subject to breaking change depending on the need of the frontend. Users should not rely on those but use the public ones instead.

    The version of the OpenAPI document: 2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from airflow_client.client.models.dag_tag_response import DagTagResponse
from typing import Optional, Set
from typing_extensions import Self

class DAGResponse(BaseModel):
    """
    DAG serializer for responses.
    """ # noqa: E501
    bundle_name: Optional[StrictStr] = None
    bundle_version: Optional[StrictStr] = None
    dag_display_name: StrictStr
    dag_id: StrictStr
    description: Optional[StrictStr] = None
    file_token: StrictStr = Field(description="Return file token.")
    fileloc: StrictStr
    has_import_errors: StrictBool
    has_task_concurrency_limits: StrictBool
    is_paused: StrictBool
    is_stale: StrictBool
    last_expired: Optional[datetime] = None
    last_parsed_time: Optional[datetime] = None
    max_active_runs: Optional[StrictInt] = None
    max_active_tasks: StrictInt
    max_consecutive_failed_dag_runs: StrictInt
    next_dagrun_data_interval_end: Optional[datetime] = None
    next_dagrun_data_interval_start: Optional[datetime] = None
    next_dagrun_logical_date: Optional[datetime] = None
    next_dagrun_run_after: Optional[datetime] = None
    owners: List[StrictStr]
    relative_fileloc: Optional[StrictStr] = None
    tags: List[DagTagResponse]
    timetable_description: Optional[StrictStr] = None
    timetable_summary: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["bundle_name", "bundle_version", "dag_display_name", "dag_id", "description", "file_token", "fileloc", "has_import_errors", "has_task_concurrency_limits", "is_paused", "is_stale", "last_expired", "last_parsed_time", "max_active_runs", "max_active_tasks", "max_consecutive_failed_dag_runs", "next_dagrun_data_interval_end", "next_dagrun_data_interval_start", "next_dagrun_logical_date", "next_dagrun_run_after", "owners", "relative_fileloc", "tags", "timetable_description", "timetable_summary"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DAGResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "file_token",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DAGResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bundle_name": obj.get("bundle_name"),
            "bundle_version": obj.get("bundle_version"),
            "dag_display_name": obj.get("dag_display_name"),
            "dag_id": obj.get("dag_id"),
            "description": obj.get("description"),
            "file_token": obj.get("file_token"),
            "fileloc": obj.get("fileloc"),
            "has_import_errors": obj.get("has_import_errors"),
            "has_task_concurrency_limits": obj.get("has_task_concurrency_limits"),
            "is_paused": obj.get("is_paused"),
            "is_stale": obj.get("is_stale"),
            "last_expired": obj.get("last_expired"),
            "last_parsed_time": obj.get("last_parsed_time"),
            "max_active_runs": obj.get("max_active_runs"),
            "max_active_tasks": obj.get("max_active_tasks"),
            "max_consecutive_failed_dag_runs": obj.get("max_consecutive_failed_dag_runs"),
            "next_dagrun_data_interval_end": obj.get("next_dagrun_data_interval_end"),
            "next_dagrun_data_interval_start": obj.get("next_dagrun_data_interval_start"),
            "next_dagrun_logical_date": obj.get("next_dagrun_logical_date"),
            "next_dagrun_run_after": obj.get("next_dagrun_run_after"),
            "owners": obj.get("owners"),
            "relative_fileloc": obj.get("relative_fileloc"),
            "tags": [DagTagResponse.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "timetable_description": obj.get("timetable_description"),
            "timetable_summary": obj.get("timetable_summary")
        })
        return _obj


