/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sender;

public class AMQPFederationCommandDispatcher
implements SenderController {
    private final Sender sender;
    private final AMQPSessionCallback session;
    private final ActiveMQServer server;
    private String controlAddress;

    AMQPFederationCommandDispatcher(Sender sender, ActiveMQServer server, AMQPSessionCallback session) {
        this.session = session;
        this.sender = sender;
        this.server = server;
    }

    public void sendPolicy(FederationReceiveFromQueuePolicy policy) throws Exception {
        Objects.requireNonNull(policy, "Cannot encode and send a null policy instance.");
        AMQPMessage command = AMQPFederationPolicySupport.encodeQueuePolicyControlMessage(policy);
        this.sendCommand(command);
    }

    public void sendPolicy(FederationReceiveFromAddressPolicy policy) throws Exception {
        Objects.requireNonNull(policy, "Cannot encode and send a null policy instance.");
        AMQPMessage command = AMQPFederationPolicySupport.encodeAddressPolicyControlMessage(policy);
        this.sendCommand(command);
    }

    public void sendCommand(AMQPMessage command) throws Exception {
        Objects.requireNonNull(command, "Null command message is not expected and constitutes an error condition");
        command.setAddress(this.getControlLinkAddress());
        this.server.getPostOffice().route((Message)command, true);
    }

    @Override
    public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
        Connection protonConnection = senderContext.getSender().getSession().getConnection();
        Record attachments = protonConnection.attachments();
        AMQPFederation federation = (AMQPFederation)attachments.get((Object)"FEDERATION_INSTANCE_RECORD", AMQPFederation.class);
        if (federation == null) {
            throw new ActiveMQAMQPIllegalStateException("Cannot create a federation link from non-federation connection");
        }
        this.controlAddress = federation.prefixControlLinkQueueName(this.sender.getRemoteTarget().getAddress());
        try {
            this.session.createTemporaryQueue(SimpleString.of((String)this.getControlLinkAddress()), RoutingType.ANYCAST, 1, true);
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
        }
        return this.session.createSender(senderContext, SimpleString.of((String)this.getControlLinkAddress()), null, false);
    }

    @Override
    public void close(boolean remoteClose) throws Exception {
        try {
            this.session.removeTemporaryQueue(SimpleString.of((String)this.getControlLinkAddress()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getControlLinkAddress() {
        return this.controlAddress;
    }
}

