/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThrottlingInflightRoutePolicyMBean;
import org.apache.camel.impl.ThrottlingInflightRoutePolicy;
import org.apache.camel.management.mbean.ManagedService;

@ManagedResource(description="Managed ThrottlingInflightRoutePolicy")
public class ManagedThrottlingInflightRoutePolicy
extends ManagedService
implements ManagedThrottlingInflightRoutePolicyMBean {
    private final ThrottlingInflightRoutePolicy policy;

    public ManagedThrottlingInflightRoutePolicy(CamelContext context, ThrottlingInflightRoutePolicy policy) {
        super(context, policy);
        this.policy = policy;
    }

    public ThrottlingInflightRoutePolicy getPolicy() {
        return this.policy;
    }

    @Override
    public int getMaxInflightExchanges() {
        return this.getPolicy().getMaxInflightExchanges();
    }

    @Override
    public void setMaxInflightExchanges(int maxInflightExchanges) {
        this.getPolicy().setMaxInflightExchanges(maxInflightExchanges);
    }

    @Override
    public int getResumePercentOfMax() {
        return this.getPolicy().getResumePercentOfMax();
    }

    @Override
    public void setResumePercentOfMax(int resumePercentOfMax) {
        this.getPolicy().setResumePercentOfMax(resumePercentOfMax);
    }

    @Override
    public String getScope() {
        return this.getPolicy().getScope().name();
    }

    @Override
    public void setScope(String scope) {
        this.getPolicy().setScope(ThrottlingInflightRoutePolicy.ThrottlingScope.valueOf(scope));
    }

    @Override
    public String getLoggingLevel() {
        return this.getPolicy().getLoggingLevel().name();
    }

    @Override
    public void setLoggingLevel(String loggingLevel) {
        LoggingLevel level = LoggingLevel.valueOf(loggingLevel);
        this.getPolicy().setLoggingLevel(level);
        this.getPolicy().getLogger().setLevel(level);
    }
}

