/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.Serializable;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.message.Message;

public abstract class JmsLogAppenderSupport
extends AbstractAppender {
    private Connection connection;
    private Session session;
    private MessageProducer producer;
    private boolean allowTextMessages = true;
    private String subjectPrefix = "log4j.";
    private static final ThreadLocal<Object> APPENDING = new ThreadLocal();

    public JmsLogAppenderSupport() {
        this("jmslog", null);
    }

    protected JmsLogAppenderSupport(String name, Filter filter) {
        super(name, filter, (Layout)null, true);
    }

    public Connection getConnection() throws JMSException, NamingException {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Session getSession() throws JMSException, NamingException {
        if (this.session == null) {
            this.session = this.createSession();
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public MessageProducer getProducer() throws JMSException, NamingException {
        if (this.producer == null) {
            this.producer = this.createProducer();
        }
        return this.producer;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public void close() {
        ArrayList<JMSException> errors = new ArrayList<JMSException>();
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (JMSException e) {
                errors.add(e);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                errors.add(e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                errors.add(e);
            }
        }
        for (JMSException e : errors) {
            this.getHandler().error("Error closing JMS resources: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void activateOptions() {
        try {
            this.getProducer();
        }
        catch (Exception e) {
            this.getHandler().error("Could not create JMS resources: " + e, (Throwable)e);
        }
    }

    protected abstract Connection createConnection() throws JMSException, NamingException;

    protected Session createSession() throws JMSException, NamingException {
        return this.getConnection().createSession(false, 1);
    }

    protected MessageProducer createProducer() throws JMSException, NamingException {
        return this.getSession().createProducer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        if (APPENDING.get() == null) {
            APPENDING.set(true);
            try {
                javax.jms.Message message = this.createMessage(event);
                Destination destination = this.getDestination(event);
                this.getProducer().send(destination, message);
            }
            catch (Exception e) {
                this.getHandler().error("Could not send message due to: " + e, event, (Throwable)e);
            }
            finally {
                APPENDING.remove();
            }
        }
    }

    protected javax.jms.Message createMessage(LogEvent event) throws JMSException, NamingException {
        Object answer = null;
        Message value = event.getMessage();
        answer = this.allowTextMessages && value instanceof String ? this.getSession().createTextMessage((String)value) : this.getSession().createObjectMessage((Serializable)value);
        answer.setStringProperty("level", event.getLevel().toString());
        answer.setIntProperty("levelInt", event.getLevel().intLevel());
        answer.setStringProperty("threadName", event.getThreadName());
        return answer;
    }

    protected Destination getDestination(LogEvent event) throws JMSException, NamingException {
        String name = this.subjectPrefix + event.getLoggerName();
        return this.getSession().createTopic(name);
    }
}

