/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Pair;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

class URIScanner {
    private static final char END = '\u0000';
    private final String charset;
    private final StringBuilder key;
    private final StringBuilder value;
    private Mode mode;
    private boolean isRaw;
    private char rawTokenEnd;

    public URIScanner(String charset) {
        this.charset = charset;
        this.key = new StringBuilder();
        this.value = new StringBuilder();
    }

    private void initState() {
        this.mode = Mode.KEY;
        this.key.setLength(0);
        this.value.setLength(0);
        this.isRaw = false;
    }

    private String getDecodedKey() throws UnsupportedEncodingException {
        return URLDecoder.decode(this.key.toString(), this.charset);
    }

    private String getDecodedValue() throws UnsupportedEncodingException {
        String s = StringHelper.replaceAll(this.value.toString(), "%", "%25");
        String answer = URLDecoder.decode(s, this.charset);
        return answer;
    }

    public Map<String, Object> parseQuery(String uri, boolean useRaw) throws URISyntaxException {
        try {
            LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>();
            this.initState();
            block6: for (int i = 0; i < uri.length(); ++i) {
                char ch = uri.charAt(i);
                char next = i <= uri.length() - 2 ? uri.charAt(i + 1) : (char)'\u0000';
                switch (this.mode) {
                    case KEY: {
                        if (ch == '=') {
                            this.mode = Mode.VALUE;
                            continue block6;
                        }
                        if (ch == '&') break;
                        this.key.append(ch);
                        break;
                    }
                    case VALUE: {
                        this.isRaw = this.checkRaw();
                        if (this.isRaw) {
                            this.value.append(ch);
                            if (!this.isAtEnd(ch, next)) continue block6;
                            this.addParameter(answer, useRaw || this.isRaw);
                            this.initState();
                            ++i;
                            continue block6;
                        }
                        if (ch == '&') break;
                        this.value.append(ch);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.mode));
                    }
                }
                if (ch != '&') continue;
                this.addParameter(answer, useRaw || this.isRaw);
                this.initState();
            }
            if (this.key.length() > 0) {
                this.addParameter(answer, useRaw || this.isRaw);
            }
            return answer;
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private boolean checkRaw() {
        this.rawTokenEnd = '\u0000';
        for (int i = 0; i < URISupport.RAW_TOKEN_START.length; ++i) {
            String rawTokenStart = "RAW" + URISupport.RAW_TOKEN_START[i];
            boolean isRaw = this.value.toString().startsWith(rawTokenStart);
            if (!isRaw) continue;
            this.rawTokenEnd = URISupport.RAW_TOKEN_END[i];
            return true;
        }
        return false;
    }

    private boolean isAtEnd(char ch, char next) {
        return ch == this.rawTokenEnd && (next == '&' || next == '\u0000');
    }

    private void addParameter(Map<String, Object> answer, boolean isRaw) throws UnsupportedEncodingException {
        String value;
        String name = this.getDecodedKey();
        String string = value = isRaw ? this.value.toString() : this.getDecodedValue();
        if (answer.containsKey(name)) {
            List list;
            Object existing = answer.get(name);
            if (existing instanceof List) {
                list = CastUtils.cast((List)existing);
            } else {
                String s;
                list = new ArrayList();
                String string2 = s = existing != null ? existing.toString() : null;
                if (s != null) {
                    list.add(s);
                }
            }
            list.add(value);
            answer.put(name, list);
        } else {
            answer.put(name, value);
        }
    }

    public static List<Pair<Integer>> scanRaw(String str) {
        ArrayList<Pair<Integer>> answer = new ArrayList<Pair<Integer>>();
        if (str == null || ObjectHelper.isEmpty(str)) {
            return answer;
        }
        int offset = 0;
        int start = str.indexOf("RAW");
        while (start >= 0 && offset < str.length()) {
            offset = start + "RAW".length();
            for (int i = 0; i < URISupport.RAW_TOKEN_START.length; ++i) {
                String tokenStart = "RAW" + URISupport.RAW_TOKEN_START[i];
                char tokenEnd = URISupport.RAW_TOKEN_END[i];
                if (!str.startsWith(tokenStart, start)) continue;
                offset = URIScanner.scanRawToEnd(str, start, tokenStart, tokenEnd, answer);
            }
            start = str.indexOf("RAW", offset);
        }
        return answer;
    }

    private static int scanRawToEnd(String str, int start, String tokenStart, char tokenEnd, List<Pair<Integer>> answer) {
        int end = str.indexOf(tokenEnd, start + tokenStart.length());
        if (end < 0) {
            answer.add(new Pair<Integer>(start, str.length()));
            return str.length();
        }
        answer.add(new Pair<Integer>(start, end));
        return end + 1;
    }

    public static boolean isRaw(int index, List<Pair<Integer>> pairs) {
        for (Pair<Integer> pair : pairs) {
            if (index < pair.getLeft()) {
                return false;
            }
            if (index > pair.getRight()) continue;
            return true;
        }
        return false;
    }

    public static boolean resolveRaw(String str, BiConsumer<String, String> consumer) {
        for (int i = 0; i < URISupport.RAW_TOKEN_START.length; ++i) {
            String tokenStart = "RAW" + URISupport.RAW_TOKEN_START[i];
            String tokenEnd = String.valueOf(URISupport.RAW_TOKEN_END[i]);
            if (!str.startsWith(tokenStart) || !str.endsWith(tokenEnd)) continue;
            String raw = str.substring(tokenStart.length(), str.length() - 1);
            consumer.accept(str, raw);
            return true;
        }
        return false;
    }

    private static enum Mode {
        KEY,
        VALUE;

    }
}

