/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

public abstract class ChildServiceSupport
extends ServiceSupport {
    private Set<Object> childServices;

    @Override
    public void start() throws Exception {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean startChildren) throws Exception {
        if (!this.started.get() && this.starting.compareAndSet(false, true)) {
            boolean childrenStarted = false;
            Exception ex = null;
            try {
                if (this.childServices != null && startChildren) {
                    ServiceHelper.startServices(this.childServices);
                }
                childrenStarted = true;
                this.doStart();
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                if (ex != null) {
                    try {
                        this.stop(childrenStarted);
                    }
                    catch (Exception exception) {}
                    throw ex;
                }
                this.started.set(true);
                this.starting.set(false);
                this.stopping.set(false);
                this.stopped.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
        }
    }

    private void stop(boolean childrenStarted) throws Exception {
        if (this.stopping.compareAndSet(false, true)) {
            try {
                try {
                    this.starting.set(false);
                    this.suspending.set(false);
                    if (childrenStarted) {
                        this.doStop();
                    }
                }
                finally {
                    this.started.set(false);
                    this.suspended.set(false);
                    if (this.childServices != null) {
                        ServiceHelper.stopServices(this.childServices);
                    }
                }
            }
            finally {
                this.stopped.set(true);
                this.stopping.set(false);
                this.starting.set(false);
                this.started.set(false);
                this.suspending.set(false);
                this.suspended.set(false);
                this.shutdown.set(false);
                this.shuttingdown.set(false);
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (!this.stopped.get()) {
            this.stop(true);
        }
    }

    @Override
    public void shutdown() throws Exception {
        this.stop();
        if (this.shuttingdown.compareAndSet(false, true)) {
            try {
                try {
                    this.doShutdown();
                }
                finally {
                    if (this.childServices != null) {
                        ServiceHelper.stopAndShutdownServices(this.childServices);
                    }
                }
            }
            finally {
                this.shutdown.set(true);
                this.shuttingdown.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildService(Object childService) {
        ChildServiceSupport childServiceSupport = this;
        synchronized (childServiceSupport) {
            if (this.childServices == null) {
                this.childServices = new LinkedHashSet<Object>();
            }
        }
        this.childServices.add(childService);
    }

    protected boolean removeChildService(Object childService) {
        return this.childServices != null && this.childServices.remove(childService);
    }
}

