/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThrottlingExceptionRoutePolicyMBean;
import org.apache.camel.impl.ThrottlingExceptionHalfOpenHandler;
import org.apache.camel.impl.ThrottlingExceptionRoutePolicy;
import org.apache.camel.management.mbean.ManagedService;

@ManagedResource(description="Managed ThrottlingExceptionRoutePolicy")
public class ManagedThrottlingExceptionRoutePolicy
extends ManagedService
implements ManagedThrottlingExceptionRoutePolicyMBean {
    private final ThrottlingExceptionRoutePolicy policy;

    public ManagedThrottlingExceptionRoutePolicy(CamelContext context, ThrottlingExceptionRoutePolicy policy) {
        super(context, policy);
        this.policy = policy;
    }

    public ThrottlingExceptionRoutePolicy getPolicy() {
        return this.policy;
    }

    @Override
    public Long getHalfOpenAfter() {
        return this.getPolicy().getHalfOpenAfter();
    }

    @Override
    public void setHalfOpenAfter(Long milliseconds) {
        this.getPolicy().setHalfOpenAfter(milliseconds);
    }

    @Override
    public Long getFailureWindow() {
        return this.getPolicy().getFailureWindow();
    }

    @Override
    public void setFailureWindow(Long milliseconds) {
        this.getPolicy().setFailureWindow(milliseconds);
    }

    @Override
    public Integer getFailureThreshold() {
        return this.getPolicy().getFailureThreshold();
    }

    @Override
    public void setFailureThreshold(Integer numberOfFailures) {
        this.getPolicy().setFailureThreshold(numberOfFailures);
    }

    @Override
    public String currentState() {
        return this.getPolicy().dumpState();
    }

    @Override
    public String getHalfOpenHandlerName() {
        ThrottlingExceptionHalfOpenHandler obj = this.getPolicy().getHalfOpenHandler();
        if (obj != null) {
            return obj.getClass().getSimpleName();
        }
        return "";
    }

    @Override
    public Integer getCurrentFailures() {
        return this.getPolicy().getFailures();
    }

    @Override
    public Long getLastFailure() {
        if (this.getPolicy().getLastFailure() == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.getPolicy().getLastFailure();
    }

    @Override
    public Long getOpenAt() {
        if (this.getPolicy().getOpenedAt() == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.getPolicy().getOpenedAt();
    }
}

