/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Service;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ServiceHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelConsumerTemplateFactoryBean
extends AbstractCamelFactoryBean<ConsumerTemplate> {
    @XmlTransient
    private ConsumerTemplate template;
    @XmlAttribute
    @Metadata(description="Sets a custom maximum cache size to use in the backing cache pools.")
    private Integer maximumCacheSize;

    @Override
    public ConsumerTemplate getObject() throws Exception {
        this.template = new DefaultConsumerTemplate(this.getCamelContext());
        if (this.maximumCacheSize != null) {
            this.template.setMaximumCacheSize(this.maximumCacheSize.intValue());
        }
        ServiceHelper.startService((Service)this.template);
        return this.template;
    }

    @Override
    public Class<ConsumerTemplate> getObjectType() {
        return ConsumerTemplate.class;
    }

    @Override
    public void destroy() throws Exception {
        ServiceHelper.stopService((Object)this.template);
    }

    public Integer getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(Integer maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }
}

