/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import org.fusesource.hawtbuf.Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.MessageSupport;

public class MQTTFrame
extends MessageSupport.HeaderBase {
    private static final Buffer[] NO_BUFFERS = new Buffer[0];
    public Buffer[] buffers = NO_BUFFERS;

    public MQTTFrame() {
    }

    public MQTTFrame(Buffer buffer) {
        this(new Buffer[]{buffer});
    }

    public MQTTFrame(Buffer[] buffers) {
        this.buffers = buffers;
    }

    public Buffer[] buffers() {
        return this.buffers;
    }

    public MQTTFrame buffers(Buffer ... buffers) {
        this.buffers = buffers;
        return this;
    }

    public MQTTFrame buffer(Buffer buffer) {
        this.buffers = new Buffer[]{buffer};
        return this;
    }

    public byte header() {
        return super.header();
    }

    public MQTTFrame header(byte header) {
        return (MQTTFrame)super.header(header);
    }

    public byte messageType() {
        return super.messageType();
    }

    public MQTTFrame commandType(int type) {
        return (MQTTFrame)super.commandType(type);
    }

    public boolean dup() {
        return super.dup();
    }

    public MQTTFrame dup(boolean dup) {
        return (MQTTFrame)super.dup(dup);
    }

    public QoS qos() {
        return super.qos();
    }

    public MQTTFrame qos(QoS qos) {
        return (MQTTFrame)super.qos(qos);
    }

    public boolean retain() {
        return super.retain();
    }

    public MQTTFrame retain(boolean retain) {
        return (MQTTFrame)super.retain(retain);
    }

    public String toString() {
        String type = "unknown";
        switch (this.messageType()) {
            case 1: {
                type = "CONNECT";
                break;
            }
            case 2: {
                type = "CONNACK";
                break;
            }
            case 14: {
                type = "DISCONNECT";
                break;
            }
            case 12: {
                type = "PINGREQ";
                break;
            }
            case 13: {
                type = "PINGRESP";
                break;
            }
            case 8: {
                type = "SUBSCRIBE";
                break;
            }
            case 10: {
                type = "UNSUBSCRIBE";
                break;
            }
            case 11: {
                type = "UNSUBACK";
                break;
            }
            case 3: {
                type = "PUBLISH";
                break;
            }
            case 9: {
                type = "SUBACK";
                break;
            }
            case 4: {
                type = "PUBACK";
                break;
            }
            case 5: {
                type = "PUBREC";
                break;
            }
            case 6: {
                type = "PUBREL";
                break;
            }
            case 7: {
                type = "PUBCOMP";
                break;
            }
        }
        return "MQTTFrame { type: " + type + ", qos: " + (Object)((Object)this.qos()) + ", dup:" + this.dup() + " }";
    }
}

