/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions.regexp;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.josql.QueryExecutionException;
import org.josql.functions.regexp.AbstractRegExpWrapper;
import org.josql.functions.regexp.RegExp;

public class OroApacheRegExpWrapper
extends AbstractRegExpWrapper
implements RegExp {
    public static final String SUPPORTED_VERSION = "2.0.8";
    private final String compilerClassName = "org.apache.oro.text.regex.Perl5Compiler";
    private final String matcherClassName = "org.apache.oro.text.regex.Perl5Matcher";
    private final String patternClassName = "org.apache.oro.text.regex.Pattern";
    private final String matchesMethName = "matches";
    private final String compileMethName = "compile";
    private Method compileMeth = null;
    private Method matchesMeth = null;
    private Object compiler = null;
    private Object matcher = null;
    private Map patterns = new HashMap();

    public String getSupportedVersion() {
        return SUPPORTED_VERSION;
    }

    public boolean isAvailable() {
        try {
            Class.forName(this.patternClassName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean match(String pattern, String val) throws QueryExecutionException {
        try {
            Object[] args;
            Object o = this.patterns.get(pattern);
            if (o == null) {
                args = new Object[]{pattern};
                o = this.compileMeth.invoke(this.compiler, args);
                this.patterns.put(pattern, o);
            }
            args = new Object[]{val, o};
            return (Boolean)this.matchesMeth.invoke(this.matcher, args);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to match value: " + val + " against pattern: " + pattern, e);
        }
    }

    public void init() throws QueryExecutionException {
        try {
            Class<?> compClass = Class.forName(this.compilerClassName);
            this.compiler = compClass.newInstance();
            Class[] argTypes = new Class[]{String.class};
            this.compileMeth = compClass.getMethod(this.compileMethName, argTypes);
            Class<?> matchClass = Class.forName(this.matcherClassName);
            this.matcher = matchClass.newInstance();
            Class<?> patternClass = Class.forName(this.patternClassName);
            Class[] argTypes2 = new Class[]{String.class, patternClass};
            this.matchesMeth = matchClass.getMethod(this.matchesMethName, argTypes2);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to init", e);
        }
    }
}

