/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.state;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.state.DNSStateTask;

public class Announcer
extends DNSStateTask {
    public Announcer(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl, Announcer.defaultTTL());
        this.setTaskState(DNSState.ANNOUNCING_1);
        this.associate(DNSState.ANNOUNCING_1);
    }

    @Override
    public String getName() {
        return "Announcer(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public String toString() {
        return super.toString() + " state: " + (Object)((Object)this.getTaskState());
    }

    @Override
    public void start(Timer timer) {
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, 1000L, 1000L);
        }
    }

    @Override
    public boolean cancel() {
        this.removeAssociation();
        return super.cancel();
    }

    @Override
    public String getTaskDescription() {
        return "announcing";
    }

    @Override
    protected boolean checkRunCondition() {
        return !this.getDns().isCanceling() && !this.getDns().isCanceled();
    }

    @Override
    protected DNSOutgoing createOutgoing() {
        return new DNSOutgoing(33792);
    }

    @Override
    protected DNSOutgoing buildOutgoingForDNS(DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        for (DNSRecord answer : this.getDns().getLocalHost().answers(DNSRecordClass.CLASS_ANY, true, this.getTTL())) {
            newOut = this.addAnswer(newOut, null, answer);
        }
        return newOut;
    }

    @Override
    protected DNSOutgoing buildOutgoingForInfo(ServiceInfoImpl info, DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        for (DNSRecord answer : info.answers(DNSRecordClass.CLASS_ANY, true, this.getTTL(), this.getDns().getLocalHost())) {
            newOut = this.addAnswer(newOut, null, answer);
        }
        return newOut;
    }

    @Override
    protected void recoverTask(Throwable e) {
        this.getDns().recover();
    }

    @Override
    protected void advanceTask() {
        this.setTaskState(this.getTaskState().advance());
        if (!this.getTaskState().isAnnouncing()) {
            this.cancel();
            this.getDns().startRenewer();
        }
    }
}

